/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.internal.cui.CUIEvent;
import com.sk89q.worldedit.session.SessionKey;
import com.sk89q.worldedit.util.auth.AuthorizationException;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.adapter.bukkit.TextAdapter;
import java.io.File;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BukkitCommandSender
implements Actor {
    private static final UUID DEFAULT_ID = UUID.fromString("a233eb4b-4cab-42cd-9fd9-7e7b9a3f74be");
    private CommandSender sender;
    private WorldEditPlugin plugin;

    public BukkitCommandSender(WorldEditPlugin plugin, CommandSender sender) {
        Preconditions.checkNotNull((Object)((Object)plugin));
        Preconditions.checkNotNull((Object)sender);
        Preconditions.checkArgument((!(sender instanceof Player) ? 1 : 0) != 0, (Object)"Cannot wrap a player");
        this.plugin = plugin;
        this.sender = sender;
    }

    public UUID getUniqueId() {
        return DEFAULT_ID;
    }

    public String getName() {
        return this.sender.getName();
    }

    public void printRaw(String msg) {
        for (String part : msg.split("\n")) {
            this.sender.sendMessage(part);
        }
    }

    public void print(String msg) {
        for (String part : msg.split("\n")) {
            this.sender.sendMessage("\u00a7d" + part);
        }
    }

    public void printDebug(String msg) {
        for (String part : msg.split("\n")) {
            this.sender.sendMessage("\u00a77" + part);
        }
    }

    public void printError(String msg) {
        for (String part : msg.split("\n")) {
            this.sender.sendMessage("\u00a7c" + part);
        }
    }

    public void print(Component component) {
        TextAdapter.sendComponent((CommandSender)this.sender, (Component)component);
    }

    public boolean canDestroyBedrock() {
        return true;
    }

    public String[] getGroups() {
        return new String[0];
    }

    public boolean hasPermission(String perm) {
        return true;
    }

    public void checkPermission(String permission) throws AuthorizationException {
    }

    public boolean isPlayer() {
        return false;
    }

    public File openFileOpenDialog(String[] extensions) {
        return null;
    }

    public File openFileSaveDialog(String[] extensions) {
        return null;
    }

    public void dispatchCUIEvent(CUIEvent event) {
    }

    public SessionKey getSessionKey() {
        return new SessionKey(){

            @Nullable
            public String getName() {
                return null;
            }

            public boolean isActive() {
                return false;
            }

            public boolean isPersistent() {
                return false;
            }

            public UUID getUniqueId() {
                return DEFAULT_ID;
            }
        };
    }
}

