/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit;

import com.destroystokyo.paper.event.server.AsyncTabCompleteEvent;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.wepif.PermissionsResolverManager;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitCommandSender;
import com.sk89q.worldedit.bukkit.BukkitConfiguration;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.bukkit.BukkitServerInterface;
import com.sk89q.worldedit.bukkit.CUIChannelListener;
import com.sk89q.worldedit.bukkit.WorldEditListener;
import com.sk89q.worldedit.bukkit.adapter.AdapterLoadException;
import com.sk89q.worldedit.bukkit.adapter.BukkitImplAdapter;
import com.sk89q.worldedit.bukkit.adapter.BukkitImplLoader;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.event.platform.CommandEvent;
import com.sk89q.worldedit.event.platform.CommandSuggestionEvent;
import com.sk89q.worldedit.event.platform.PlatformReadyEvent;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.extension.platform.Platform;
import com.sk89q.worldedit.extent.inventory.BlockBag;
import com.sk89q.worldedit.internal.command.CommandUtil;
import com.sk89q.worldedit.registry.Keyed;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.session.SessionOwner;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockCategory;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.FuzzyBlockState;
import com.sk89q.worldedit.world.gamemode.GameModes;
import com.sk89q.worldedit.world.item.ItemCategory;
import com.sk89q.worldedit.world.item.ItemType;
import com.sk89q.worldedit.world.weather.WeatherTypes;
import io.papermc.lib.PaperLib;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import javax.annotation.Nullable;
import org.bstats.bukkit.Metrics;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Biome;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldEditPlugin
extends JavaPlugin
implements TabCompleter {
    private static final Logger log = LoggerFactory.getLogger(WorldEditPlugin.class);
    static final String CUI_PLUGIN_CHANNEL = "worldedit:cui";
    private static WorldEditPlugin INSTANCE;
    private static WorldInitListener worldInitListener;
    private BukkitImplAdapter bukkitAdapter;
    private BukkitServerInterface server;
    private BukkitConfiguration config;

    public void onLoad() {
        INSTANCE = this;
        this.getDataFolder().mkdirs();
        WorldEdit worldEdit = WorldEdit.getInstance();
        this.server = new BukkitServerInterface(this, this.getServer());
        worldEdit.getPlatformManager().register((Platform)this.server);
    }

    public void onEnable() {
        PermissionsResolverManager.initialize((Plugin)this);
        this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, CUI_PLUGIN_CHANNEL, (PluginMessageListener)new CUIChannelListener(this));
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, CUI_PLUGIN_CHANNEL);
        this.getServer().getPluginManager().registerEvents((Listener)new WorldEditListener(this), (Plugin)this);
        if (PaperLib.isPaper()) {
            this.getServer().getPluginManager().registerEvents((Listener)new AsyncTabCompleteListener(), (Plugin)this);
        }
        if (worldInitListener != null) {
            this.getLogger().warning("Server reload detected. This may cause various issues with WorldEdit and dependant plugins.");
            try {
                this.loadAdapter();
                this.loadConfig();
            }
            catch (Throwable throwable) {}
        } else {
            worldInitListener = new WorldInitListener();
            this.getServer().getPluginManager().registerEvents((Listener)worldInitListener, (Plugin)this);
        }
        new Metrics((Plugin)this);
        PaperLib.suggestPaper((Plugin)this);
    }

    private void setupWorldData() {
        this.loadAdapter();
        this.setupRegistries();
        WorldEdit.getInstance().loadMappings();
        this.loadConfig();
        this.setupTags();
        WorldEdit.getInstance().getEventBus().post((Object)new PlatformReadyEvent());
    }

    private void setupRegistries() {
        for (Biome biome : Biome.values()) {
            String lowerCaseBiomeName = biome.name().toLowerCase(Locale.ROOT);
            BiomeType.REGISTRY.register("minecraft:" + lowerCaseBiomeName, (Keyed)new BiomeType("minecraft:" + lowerCaseBiomeName));
        }
        for (Biome biome : Material.values()) {
            if (biome.isBlock() && !biome.isLegacy()) {
                BlockType.REGISTRY.register(biome.getKey().toString(), (Keyed)new BlockType(biome.getKey().toString(), arg_0 -> this.lambda$setupRegistries$0((Material)biome, arg_0)));
            }
            if (!biome.isItem() || biome.isLegacy()) continue;
            ItemType.REGISTRY.register(biome.getKey().toString(), (Keyed)new ItemType(biome.getKey().toString()));
        }
        for (Biome biome : EntityType.values()) {
            String mcid = biome.getName();
            if (mcid == null) continue;
            String lowerCaseMcId = mcid.toLowerCase(Locale.ROOT);
            com.sk89q.worldedit.world.entity.EntityType.REGISTRY.register("minecraft:" + lowerCaseMcId, (Keyed)new com.sk89q.worldedit.world.entity.EntityType("minecraft:" + lowerCaseMcId));
        }
        GameModes.get((String)"");
        WeatherTypes.get((String)"");
    }

    private void setupTags() {
        try {
            for (Tag blockTag : Bukkit.getTags((String)"blocks", Material.class)) {
                BlockCategory.REGISTRY.register(blockTag.getKey().toString(), (Keyed)new BlockCategory(blockTag.getKey().toString()));
            }
            for (Tag itemTag : Bukkit.getTags((String)"items", Material.class)) {
                ItemCategory.REGISTRY.register(itemTag.getKey().toString(), (Keyed)new ItemCategory(itemTag.getKey().toString()));
            }
        }
        catch (NoSuchMethodError ignored) {
            this.getLogger().warning("The version of Spigot/Paper you are using doesn't support Tags. The usage of tags with WorldEdit will not work until you update.");
        }
    }

    private void loadConfig() {
        this.createDefaultConfiguration("config.yml");
        this.config = new BukkitConfiguration(new YAMLProcessor(new File(this.getDataFolder(), "config.yml"), true), this);
        this.config.load();
    }

    private void loadAdapter() {
        WorldEdit worldEdit = WorldEdit.getInstance();
        BukkitImplLoader adapterLoader = new BukkitImplLoader();
        try {
            adapterLoader.addFromPath(((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (IOException e) {
            log.warn("Failed to search path for Bukkit adapters");
        }
        try {
            adapterLoader.addFromJar(this.getFile());
        }
        catch (IOException e) {
            log.warn("Failed to search " + this.getFile() + " for Bukkit adapters", (Throwable)e);
        }
        try {
            this.bukkitAdapter = adapterLoader.loadAdapter();
            log.info("Using " + this.bukkitAdapter.getClass().getCanonicalName() + " as the Bukkit adapter");
        }
        catch (AdapterLoadException e) {
            Platform platform = worldEdit.getPlatformManager().queryCapability(Capability.WORLD_EDITING);
            if (platform instanceof BukkitServerInterface) {
                log.warn(e.getMessage());
            }
            log.info("WorldEdit could not find a Bukkit adapter for this MC version, but it seems that you have another implementation of WorldEdit installed (" + platform.getPlatformName() + ") that handles the world editing.");
        }
    }

    public void onDisable() {
        WorldEdit worldEdit = WorldEdit.getInstance();
        worldEdit.getSessionManager().unload();
        worldEdit.getPlatformManager().unregister((Platform)this.server);
        if (this.config != null) {
            this.config.unload();
        }
        if (this.server != null) {
            this.server.unregisterCommands();
        }
        this.getServer().getScheduler().cancelTasks((Plugin)this);
    }

    protected void loadConfiguration() {
        this.config.unload();
        this.config.load();
        this.getPermissionsResolver().load();
    }

    protected void createDefaultConfiguration(String name) {
        File actual = new File(this.getDataFolder(), name);
        if (!actual.exists()) {
            try (JarFile file = new JarFile(this.getFile());){
                ZipEntry copy = file.getEntry("defaults/" + name);
                if (copy == null) {
                    throw new FileNotFoundException();
                }
                this.copyDefaultConfig(file.getInputStream(copy), actual, name);
            }
            catch (IOException e) {
                this.getLogger().severe("Unable to read default configuration: " + name);
            }
        }
    }

    private void copyDefaultConfig(InputStream input, File actual, String name) {
        try (FileOutputStream output = new FileOutputStream(actual);){
            int length;
            byte[] buf = new byte[8192];
            while ((length = input.read(buf)) > 0) {
                output.write(buf, 0, length);
            }
            this.getLogger().info("Default configuration file written: " + name);
        }
        catch (IOException e) {
            this.getLogger().log(Level.WARNING, "Failed to write default config file", e);
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        Object[] split = new String[args.length + 1];
        System.arraycopy(args, 0, split, 1, args.length);
        split[0] = "/" + cmd.getName();
        CommandEvent event = new CommandEvent(this.wrapCommandSender(sender), Joiner.on((String)" ").join(split));
        this.getWorldEdit().getEventBus().post((Object)event);
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        Object[] split = new String[args.length + 1];
        System.arraycopy(args, 0, split, 1, args.length);
        split[0] = "/" + cmd.getName();
        String arguments = Joiner.on((String)" ").join(split);
        CommandSuggestionEvent event = new CommandSuggestionEvent(this.wrapCommandSender(sender), arguments);
        this.getWorldEdit().getEventBus().post((Object)event);
        return CommandUtil.fixSuggestions((String)arguments, (List)event.getSuggestions());
    }

    public LocalSession getSession(org.bukkit.entity.Player player) {
        return WorldEdit.getInstance().getSessionManager().get((SessionOwner)this.wrapPlayer(player));
    }

    public EditSession createEditSession(org.bukkit.entity.Player player) {
        BukkitPlayer wePlayer = this.wrapPlayer(player);
        LocalSession session = WorldEdit.getInstance().getSessionManager().get((SessionOwner)wePlayer);
        BlockBag blockBag = session.getBlockBag((Player)wePlayer);
        EditSession editSession = WorldEdit.getInstance().getEditSessionFactory().getEditSession(wePlayer.getWorld(), session.getBlockChangeLimit(), blockBag, (Player)wePlayer);
        editSession.enableStandardMode();
        return editSession;
    }

    public void remember(org.bukkit.entity.Player player, EditSession editSession) {
        BukkitPlayer wePlayer = this.wrapPlayer(player);
        LocalSession session = WorldEdit.getInstance().getSessionManager().get((SessionOwner)wePlayer);
        session.remember(editSession);
        editSession.flushSession();
        WorldEdit.getInstance().flushBlockBag((Actor)wePlayer, editSession);
    }

    public BukkitConfiguration getLocalConfiguration() {
        return this.config;
    }

    public PermissionsResolverManager getPermissionsResolver() {
        return PermissionsResolverManager.getInstance();
    }

    public BukkitPlayer wrapPlayer(org.bukkit.entity.Player player) {
        return new BukkitPlayer(this, player);
    }

    public Actor wrapCommandSender(CommandSender sender) {
        if (sender instanceof org.bukkit.entity.Player) {
            return this.wrapPlayer((org.bukkit.entity.Player)sender);
        }
        return new BukkitCommandSender(this, sender);
    }

    BukkitServerInterface getInternalPlatform() {
        return this.server;
    }

    public WorldEdit getWorldEdit() {
        return WorldEdit.getInstance();
    }

    static WorldEditPlugin getInstance() {
        return (WorldEditPlugin)((Object)Preconditions.checkNotNull((Object)((Object)INSTANCE)));
    }

    @Nullable
    BukkitImplAdapter getBukkitImplAdapter() {
        return this.bukkitAdapter;
    }

    private /* synthetic */ BlockState lambda$setupRegistries$0(Material material, BlockState blockState) {
        ParserContext context = new ParserContext();
        context.setPreferringWildcard(true);
        context.setTryLegacy(false);
        context.setRestricted(false);
        try {
            FuzzyBlockState state = (FuzzyBlockState)((BaseBlock)WorldEdit.getInstance().getBlockFactory().parseFromInput(BukkitAdapter.adapt(blockState.getBlockType()).createBlockData().getAsString(), context)).toImmutableState();
            BlockState defaultState = (BlockState)blockState.getBlockType().getAllStates().get(0);
            for (Map.Entry propertyObjectEntry : state.getStates().entrySet()) {
                defaultState = defaultState.with((Property)propertyObjectEntry.getKey(), propertyObjectEntry.getValue());
            }
            return defaultState;
        }
        catch (InputParseException e) {
            this.getLogger().log(Level.WARNING, "Error loading block state for " + material.getKey(), e);
            return blockState;
        }
    }

    static {
        worldInitListener = null;
    }

    private class AsyncTabCompleteListener
    implements Listener {
        AsyncTabCompleteListener() {
        }

        @EventHandler(ignoreCancelled=true)
        public void onAsyncTabComplete(AsyncTabCompleteEvent event) {
            if (!event.isCommand()) {
                return;
            }
            String buffer = event.getBuffer();
            String[] parts = buffer.split(" ");
            if (parts.length < 1) {
                return;
            }
            String label = parts[0];
            Optional command = WorldEdit.getInstance().getPlatformManager().getPlatformCommandManager().getCommandManager().getCommand(label);
            if (!command.isPresent()) {
                return;
            }
            CommandSuggestionEvent suggestEvent = new CommandSuggestionEvent(WorldEditPlugin.this.wrapCommandSender(event.getSender()), event.getBuffer());
            WorldEditPlugin.this.getWorldEdit().getEventBus().post((Object)suggestEvent);
            event.setCompletions(CommandUtil.fixSuggestions((String)event.getBuffer(), (List)suggestEvent.getSuggestions()));
            event.setHandled(true);
        }
    }

    private class WorldInitListener
    implements Listener {
        private boolean loaded = false;

        private WorldInitListener() {
        }

        @EventHandler(priority=EventPriority.LOWEST)
        public void onWorldInit(WorldInitEvent event) {
            if (this.loaded) {
                return;
            }
            this.loaded = true;
            WorldEditPlugin.this.setupWorldData();
        }
    }
}

