/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitEntity;
import com.sk89q.worldedit.bukkit.EditSessionBlockChangeDelegate;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.bukkit.WorldUnloadedException;
import com.sk89q.worldedit.bukkit.adapter.BukkitImplAdapter;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.history.change.BlockChange;
import com.sk89q.worldedit.history.change.Change;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.TreeGenerator;
import com.sk89q.worldedit.world.AbstractWorld;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.weather.WeatherType;
import com.sk89q.worldedit.world.weather.WeatherTypes;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.bukkit.BlockChangeDelegate;
import org.bukkit.Effect;
import org.bukkit.TreeType;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.inventory.DoubleChestInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.slf4j.Logger;

public class BukkitWorld
extends AbstractWorld {
    private static final Logger logger = WorldEdit.logger;
    private static final Map<Integer, Effect> effects = new HashMap<Integer, Effect>();
    private final WeakReference<org.bukkit.World> worldRef;
    private static final EnumMap<TreeGenerator.TreeType, TreeType> treeTypeMapping;

    public BukkitWorld(org.bukkit.World world) {
        this.worldRef = new WeakReference<org.bukkit.World>(world);
    }

    public List<Entity> getEntities(Region region) {
        org.bukkit.World world = this.getWorld();
        List ents = world.getEntities();
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (org.bukkit.entity.Entity ent : ents) {
            if (!region.contains(BukkitAdapter.asBlockVector(ent.getLocation()))) continue;
            entities.add(BukkitAdapter.adapt(ent));
        }
        return entities;
    }

    public List<Entity> getEntities() {
        ArrayList<Entity> list = new ArrayList<Entity>();
        for (org.bukkit.entity.Entity entity : this.getWorld().getEntities()) {
            list.add(BukkitAdapter.adapt(entity));
        }
        return list;
    }

    @Nullable
    public Entity createEntity(Location location, BaseEntity entity) {
        BukkitImplAdapter adapter = WorldEditPlugin.getInstance().getBukkitImplAdapter();
        if (adapter != null) {
            try {
                org.bukkit.entity.Entity createdEntity = adapter.createEntity(BukkitAdapter.adapt(this.getWorld(), location), entity);
                if (createdEntity != null) {
                    return new BukkitEntity(createdEntity);
                }
                return null;
            }
            catch (Exception e) {
                logger.warn("Corrupt entity found when creating: " + entity.getType().getId());
                if (entity.getNbtData() != null) {
                    logger.warn(entity.getNbtData().toString());
                }
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public org.bukkit.World getWorld() {
        return (org.bukkit.World)Preconditions.checkNotNull(this.worldRef.get(), (Object)"The world was unloaded and the reference is unavailable");
    }

    protected org.bukkit.World getWorldChecked() throws WorldEditException {
        org.bukkit.World world = (org.bukkit.World)this.worldRef.get();
        if (world == null) {
            throw new WorldUnloadedException();
        }
        return world;
    }

    public String getName() {
        return this.getWorld().getName();
    }

    public int getBlockLightLevel(BlockVector3 pt) {
        return this.getWorld().getBlockAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ()).getLightLevel();
    }

    public boolean regenerate(Region region, EditSession editSession) {
        BaseBlock[] history = new BaseBlock[256 * (this.getMaxY() + 1)];
        for (BlockVector2 chunk : region.getChunks()) {
            int index;
            BlockVector3 pt;
            int z;
            int y;
            int x;
            BlockVector3 min = BlockVector3.at((int)(chunk.getBlockX() * 16), (int)0, (int)(chunk.getBlockZ() * 16));
            for (x = 0; x < 16; ++x) {
                for (y = 0; y < this.getMaxY() + 1; ++y) {
                    for (z = 0; z < 16; ++z) {
                        pt = min.add(x, y, z);
                        index = y * 16 * 16 + z * 16 + x;
                        history[index] = editSession.getFullBlock(pt);
                    }
                }
            }
            try {
                this.getWorld().regenerateChunk(chunk.getBlockX(), chunk.getBlockZ());
            }
            catch (Throwable t) {
                logger.warn("Chunk generation via Bukkit raised an error", t);
            }
            for (x = 0; x < 16; ++x) {
                for (y = 0; y < this.getMaxY() + 1; ++y) {
                    for (z = 0; z < 16; ++z) {
                        pt = min.add(x, y, z);
                        index = y * 16 * 16 + z * 16 + x;
                        if (!region.contains(pt)) {
                            editSession.smartSetBlock(pt, (BlockStateHolder)history[index]);
                            continue;
                        }
                        editSession.getChangeSet().add((Change)new BlockChange(pt, (BlockStateHolder)history[index], (BlockStateHolder)editSession.getFullBlock(pt)));
                    }
                }
            }
        }
        return true;
    }

    private Inventory getBlockInventory(Chest chest) {
        try {
            return chest.getBlockInventory();
        }
        catch (Throwable t) {
            if (chest.getInventory() instanceof DoubleChestInventory) {
                DoubleChestInventory inven = (DoubleChestInventory)chest.getInventory();
                if (inven.getLeftSide().getHolder().equals(chest)) {
                    return inven.getLeftSide();
                }
                if (inven.getRightSide().getHolder().equals(chest)) {
                    return inven.getRightSide();
                }
                return inven;
            }
            return chest.getInventory();
        }
    }

    public boolean clearContainerBlockContents(BlockVector3 pt) {
        Block block = this.getWorld().getBlockAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ());
        if (block == null) {
            return false;
        }
        BlockState state = block.getState();
        if (!(state instanceof InventoryHolder)) {
            return false;
        }
        InventoryHolder chest = (InventoryHolder)state;
        Inventory inven = chest.getInventory();
        if (chest instanceof Chest) {
            inven = this.getBlockInventory((Chest)chest);
        }
        inven.clear();
        return true;
    }

    public static TreeType toBukkitTreeType(TreeGenerator.TreeType type) {
        return treeTypeMapping.get(type);
    }

    public boolean generateTree(TreeGenerator.TreeType type, EditSession editSession, BlockVector3 pt) {
        org.bukkit.World world = this.getWorld();
        TreeType bukkitType = BukkitWorld.toBukkitTreeType(type);
        return type != null && world.generateTree(BukkitAdapter.adapt(world, pt), bukkitType, (BlockChangeDelegate)new EditSessionBlockChangeDelegate(editSession));
    }

    public void dropItem(Vector3 pt, BaseItemStack item) {
        org.bukkit.World world = this.getWorld();
        world.dropItemNaturally(BukkitAdapter.adapt(world, pt), BukkitAdapter.adapt(item));
    }

    public void checkLoadedChunk(BlockVector3 pt) {
        org.bukkit.World world = this.getWorld();
        if (!world.isChunkLoaded(pt.getBlockX() >> 4, pt.getBlockZ() >> 4)) {
            world.loadChunk(pt.getBlockX() >> 4, pt.getBlockZ() >> 4);
        }
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof BukkitWorld) {
            return ((BukkitWorld)((Object)other)).getWorld().equals(this.getWorld());
        }
        if (other instanceof World) {
            return ((World)other).getName().equals(this.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getWorld().hashCode();
    }

    public int getMaxY() {
        return this.getWorld().getMaxHeight() - 1;
    }

    public void fixAfterFastMode(Iterable<BlockVector2> chunks) {
        org.bukkit.World world = this.getWorld();
        for (BlockVector2 chunkPos : chunks) {
            world.refreshChunk(chunkPos.getBlockX(), chunkPos.getBlockZ());
        }
    }

    public boolean playEffect(Vector3 position, int type, int data) {
        org.bukkit.World world = this.getWorld();
        Effect effect = effects.get(type);
        if (effect == null) {
            return false;
        }
        world.playEffect(BukkitAdapter.adapt(world, position), effect, data);
        return true;
    }

    public WeatherType getWeather() {
        if (this.getWorld().isThundering()) {
            return WeatherTypes.THUNDER_STORM;
        }
        if (this.getWorld().hasStorm()) {
            return WeatherTypes.RAIN;
        }
        return WeatherTypes.CLEAR;
    }

    public long getRemainingWeatherDuration() {
        return this.getWorld().getWeatherDuration();
    }

    public void setWeather(WeatherType weatherType) {
        if (weatherType == WeatherTypes.THUNDER_STORM) {
            this.getWorld().setThundering(true);
        } else if (weatherType == WeatherTypes.RAIN) {
            this.getWorld().setStorm(true);
        } else {
            this.getWorld().setStorm(false);
            this.getWorld().setThundering(false);
        }
    }

    public void setWeather(WeatherType weatherType, long duration) {
        if (weatherType == WeatherTypes.THUNDER_STORM) {
            this.getWorld().setThundering(true);
            this.getWorld().setThunderDuration((int)duration);
            this.getWorld().setWeatherDuration((int)duration);
        } else if (weatherType == WeatherTypes.RAIN) {
            this.getWorld().setStorm(true);
            this.getWorld().setWeatherDuration((int)duration);
        } else {
            this.getWorld().setStorm(false);
            this.getWorld().setThundering(false);
            this.getWorld().setWeatherDuration((int)duration);
        }
    }

    public BlockVector3 getSpawnPosition() {
        return BukkitAdapter.asBlockVector(this.getWorld().getSpawnLocation());
    }

    public void simulateBlockMine(BlockVector3 pt) {
        this.getWorld().getBlockAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ()).breakNaturally();
    }

    public com.sk89q.worldedit.world.block.BlockState getBlock(BlockVector3 position) {
        Block bukkitBlock = this.getWorld().getBlockAt(position.getBlockX(), position.getBlockY(), position.getBlockZ());
        return BukkitAdapter.adapt(bukkitBlock.getBlockData());
    }

    public <B extends BlockStateHolder<B>> boolean setBlock(BlockVector3 position, B block, boolean notifyAndLight) throws WorldEditException {
        BukkitImplAdapter adapter = WorldEditPlugin.getInstance().getBukkitImplAdapter();
        if (adapter != null) {
            try {
                return adapter.setBlock(BukkitAdapter.adapt(this.getWorld(), position), block, notifyAndLight);
            }
            catch (Exception e) {
                if (block instanceof BaseBlock && ((BaseBlock)block).getNbtData() != null) {
                    logger.warn("Tried to set a corrupt tile entity at " + position.toString());
                    logger.warn(((BaseBlock)block).getNbtData().toString());
                }
                e.printStackTrace();
                Block bukkitBlock = this.getWorld().getBlockAt(position.getBlockX(), position.getBlockY(), position.getBlockZ());
                bukkitBlock.setBlockData(BukkitAdapter.adapt(block), notifyAndLight);
                return true;
            }
        }
        Block bukkitBlock = this.getWorld().getBlockAt(position.getBlockX(), position.getBlockY(), position.getBlockZ());
        bukkitBlock.setBlockData(BukkitAdapter.adapt(block), notifyAndLight);
        return true;
    }

    public BaseBlock getFullBlock(BlockVector3 position) {
        BukkitImplAdapter adapter = WorldEditPlugin.getInstance().getBukkitImplAdapter();
        if (adapter != null) {
            return adapter.getBlock(BukkitAdapter.adapt(this.getWorld(), position));
        }
        return this.getBlock(position).toBaseBlock();
    }

    public boolean notifyAndLightBlock(BlockVector3 position, com.sk89q.worldedit.world.block.BlockState previousType) throws WorldEditException {
        BukkitImplAdapter adapter = WorldEditPlugin.getInstance().getBukkitImplAdapter();
        if (adapter != null) {
            adapter.notifyAndLightBlock(BukkitAdapter.adapt(this.getWorld(), position), previousType);
            return true;
        }
        return false;
    }

    public BiomeType getBiome(BlockVector2 position) {
        return BukkitAdapter.adapt(this.getWorld().getBiome(position.getBlockX(), position.getBlockZ()));
    }

    public boolean setBiome(BlockVector2 position, BiomeType biome) {
        this.getWorld().setBiome(position.getBlockX(), position.getBlockZ(), BukkitAdapter.adapt(biome));
        return true;
    }

    static {
        for (Effect effect : Effect.values()) {
            effects.put(effect.getId(), effect);
        }
        treeTypeMapping = new EnumMap(TreeGenerator.TreeType.class);
        for (Effect effect : TreeGenerator.TreeType.values()) {
            try {
                TreeType bukkitType = TreeType.valueOf((String)effect.name());
                treeTypeMapping.put((TreeGenerator.TreeType)effect, bukkitType);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        treeTypeMapping.put(TreeGenerator.TreeType.SHORT_JUNGLE, TreeType.SMALL_JUNGLE);
        treeTypeMapping.put(TreeGenerator.TreeType.RANDOM, TreeType.BROWN_MUSHROOM);
        treeTypeMapping.put(TreeGenerator.TreeType.RANDOM_REDWOOD, TreeType.REDWOOD);
        treeTypeMapping.put(TreeGenerator.TreeType.PINE, TreeType.REDWOOD);
        treeTypeMapping.put(TreeGenerator.TreeType.RANDOM_BIRCH, TreeType.BIRCH);
        treeTypeMapping.put(TreeGenerator.TreeType.RANDOM_JUNGLE, TreeType.JUNGLE);
        treeTypeMapping.put(TreeGenerator.TreeType.RANDOM_MUSHROOM, TreeType.BROWN_MUSHROOM);
        for (Effect effect : TreeGenerator.TreeType.values()) {
            if (treeTypeMapping.get(effect) != null) continue;
            WorldEdit.logger.error("No TreeType mapping for TreeGenerator.TreeType." + effect);
        }
    }
}

