/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit;

import com.google.common.base.Preconditions;
import com.sk89q.bukkit.util.CommandInspector;
import com.sk89q.worldedit.bukkit.BukkitTextAdapter;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.extension.platform.Actor;
import java.util.Optional;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.NoInputCommandParameters;
import org.enginehub.piston.inject.InjectedValueAccess;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.inject.MapBackedValueStore;
import org.enginehub.piston.inject.MemoizingValueAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BukkitCommandInspector
implements CommandInspector {
    private static final Logger logger = LoggerFactory.getLogger(BukkitCommandInspector.class);
    private final WorldEditPlugin plugin;
    private final CommandManager dispatcher;

    BukkitCommandInspector(WorldEditPlugin plugin, CommandManager dispatcher) {
        Preconditions.checkNotNull((Object)((Object)plugin));
        Preconditions.checkNotNull((Object)dispatcher);
        this.plugin = plugin;
        this.dispatcher = dispatcher;
    }

    @Override
    public String getShortText(Command command) {
        Optional mapping = this.dispatcher.getCommand(command.getName());
        if (mapping.isPresent()) {
            return BukkitTextAdapter.reduceToText(((org.enginehub.piston.Command)mapping.get()).getDescription());
        }
        logger.warn("BukkitCommandInspector doesn't know how about the command '" + command + "'");
        return "Help text not available";
    }

    @Override
    public String getFullText(Command command) {
        Optional mapping = this.dispatcher.getCommand(command.getName());
        if (mapping.isPresent()) {
            return BukkitTextAdapter.reduceToText(((org.enginehub.piston.Command)mapping.get()).getFullHelp());
        }
        logger.warn("BukkitCommandInspector doesn't know how about the command '" + command + "'");
        return "Help text not available";
    }

    @Override
    public boolean testPermission(CommandSender sender, Command command) {
        Optional mapping = this.dispatcher.getCommand(command.getName());
        if (mapping.isPresent()) {
            MapBackedValueStore store = MapBackedValueStore.create();
            store.injectValue(Key.of(Actor.class), context -> Optional.of(this.plugin.wrapCommandSender(sender)));
            NoInputCommandParameters parameters = NoInputCommandParameters.builder().injectedValues((InjectedValueAccess)MemoizingValueAccess.wrap((InjectedValueAccess)store)).build();
            return ((org.enginehub.piston.Command)mapping.get()).getCondition().satisfied((CommandParameters)parameters);
        }
        logger.warn("BukkitCommandInspector doesn't know how about the command '" + command + "'");
        return false;
    }
}

