/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit;

import com.sk89q.bukkit.util.CommandInfo;
import com.sk89q.bukkit.util.CommandRegistration;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitCommandInspector;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.bukkit.BukkitRegistries;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.extension.platform.MultiUserPlatform;
import com.sk89q.worldedit.extension.platform.Preference;
import com.sk89q.worldedit.util.command.CommandMapping;
import com.sk89q.worldedit.util.command.Description;
import com.sk89q.worldedit.util.command.Dispatcher;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.registry.Registries;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.entity.EntityType;
import org.bukkit.plugin.Plugin;

public class BukkitServerInterface
implements MultiUserPlatform {
    public Server server;
    public WorldEditPlugin plugin;
    private CommandRegistration dynamicCommands;
    private boolean hookingEvents;

    public BukkitServerInterface(WorldEditPlugin plugin, Server server) {
        this.plugin = plugin;
        this.server = server;
        this.dynamicCommands = new CommandRegistration((Plugin)plugin);
    }

    boolean isHookingEvents() {
        return this.hookingEvents;
    }

    public Registries getRegistries() {
        return BukkitRegistries.getInstance();
    }

    public int getDataVersion() {
        if (this.plugin.getBukkitImplAdapter() != null) {
            return this.plugin.getBukkitImplAdapter().getDataVersion();
        }
        return 0;
    }

    public boolean isValidMobType(String type) {
        EntityType entityType = EntityType.fromName((String)type);
        return entityType != null && entityType.isAlive();
    }

    public void reload() {
        this.plugin.loadConfiguration();
    }

    public int schedule(long delay, long period, Runnable task) {
        return Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, task, delay, period);
    }

    public List<World> getWorlds() {
        List worlds = this.server.getWorlds();
        ArrayList<World> ret = new ArrayList<World>(worlds.size());
        for (org.bukkit.World world : worlds) {
            ret.add(BukkitAdapter.adapt(world));
        }
        return ret;
    }

    @Nullable
    public Player matchPlayer(Player player) {
        if (player instanceof BukkitPlayer) {
            return player;
        }
        org.bukkit.entity.Player bukkitPlayer = this.server.getPlayerExact(player.getName());
        return bukkitPlayer != null ? WorldEditPlugin.getInstance().wrapPlayer(bukkitPlayer) : null;
    }

    @Nullable
    public BukkitWorld matchWorld(World world) {
        if (world instanceof BukkitWorld) {
            return (BukkitWorld)world;
        }
        org.bukkit.World bukkitWorld = this.server.getWorld(world.getName());
        return bukkitWorld != null ? new BukkitWorld(bukkitWorld) : null;
    }

    public void registerCommands(Dispatcher dispatcher) {
        ArrayList<CommandInfo> toRegister = new ArrayList<CommandInfo>();
        BukkitCommandInspector inspector = new BukkitCommandInspector(this.plugin, dispatcher);
        for (CommandMapping command : dispatcher.getCommands()) {
            Description description = command.getDescription();
            List permissions = description.getPermissions();
            String[] permissionsArray = new String[permissions.size()];
            permissions.toArray(permissionsArray);
            toRegister.add(new CommandInfo(description.getUsage(), description.getDescription(), command.getAllAliases(), inspector, permissionsArray));
        }
        this.dynamicCommands.register(toRegister);
    }

    public void registerGameHooks() {
        this.hookingEvents = true;
    }

    public LocalConfiguration getConfiguration() {
        return this.plugin.getLocalConfiguration();
    }

    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public String getPlatformName() {
        return "Bukkit-Official";
    }

    public String getPlatformVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public Map<Capability, Preference> getCapabilities() {
        EnumMap<Capability, Preference> capabilities = new EnumMap<Capability, Preference>(Capability.class);
        capabilities.put(Capability.CONFIGURATION, Preference.NORMAL);
        capabilities.put(Capability.WORLDEDIT_CUI, Preference.NORMAL);
        capabilities.put(Capability.GAME_HOOKS, Preference.PREFERRED);
        capabilities.put(Capability.PERMISSIONS, Preference.PREFERRED);
        capabilities.put(Capability.USER_COMMANDS, Preference.PREFERRED);
        capabilities.put(Capability.WORLD_EDITING, Preference.PREFER_OTHERS);
        return capabilities;
    }

    public void unregisterCommands() {
        this.dynamicCommands.unregisterCommands();
    }

    public Collection<Actor> getConnectedUsers() {
        ArrayList<Actor> users = new ArrayList<Actor>();
        for (org.bukkit.entity.Player player : Bukkit.getServer().getOnlinePlayers()) {
            users.add((Actor)WorldEditPlugin.getInstance().wrapPlayer(player));
        }
        return users;
    }
}

