/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit;

import com.sk89q.util.StringUtil;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitPlayerBlockBag;
import com.sk89q.worldedit.bukkit.CUIChannelListener;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.bukkit.adapter.BukkitImplAdapter;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.extension.platform.AbstractPlayerActor;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.inventory.BlockBag;
import com.sk89q.worldedit.internal.cui.CUIEvent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.session.SessionKey;
import com.sk89q.worldedit.util.HandSide;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.adapter.bukkit.TextAdapter;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.gamemode.GameMode;
import com.sk89q.worldedit.world.gamemode.GameModes;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class BukkitPlayer
extends AbstractPlayerActor {
    private Player player;
    private WorldEditPlugin plugin;

    public BukkitPlayer(Player player) {
        this(WorldEditPlugin.getInstance(), player);
    }

    public BukkitPlayer(WorldEditPlugin plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
    }

    public UUID getUniqueId() {
        return this.player.getUniqueId();
    }

    public BaseItemStack getItemInHand(HandSide handSide) {
        ItemStack itemStack = handSide == HandSide.MAIN_HAND ? this.player.getInventory().getItemInMainHand() : this.player.getInventory().getItemInOffHand();
        return BukkitAdapter.adapt(itemStack);
    }

    public BaseBlock getBlockInHand(HandSide handSide) throws WorldEditException {
        ItemStack itemStack = handSide == HandSide.MAIN_HAND ? this.player.getInventory().getItemInMainHand() : this.player.getInventory().getItemInOffHand();
        return BukkitAdapter.asBlockState(itemStack).toBaseBlock();
    }

    public String getName() {
        return this.player.getName();
    }

    public String getDisplayName() {
        return this.player.getDisplayName();
    }

    public void giveItem(BaseItemStack itemStack) {
        this.player.getInventory().addItem(new ItemStack[]{BukkitAdapter.adapt(itemStack)});
    }

    public void printRaw(String msg) {
        for (String part : msg.split("\n")) {
            this.player.sendMessage(part);
        }
    }

    public void print(String msg) {
        for (String part : msg.split("\n")) {
            this.player.sendMessage("\u00a7d" + part);
        }
    }

    public void printDebug(String msg) {
        for (String part : msg.split("\n")) {
            this.player.sendMessage("\u00a77" + part);
        }
    }

    public void printError(String msg) {
        for (String part : msg.split("\n")) {
            this.player.sendMessage("\u00a7c" + part);
        }
    }

    public void print(TextComponent component) {
        TextAdapter.sendComponent((CommandSender)this.player, (Component)component);
    }

    public void setPosition(Vector3 pos, float pitch, float yaw) {
        this.player.teleport(new Location(this.player.getWorld(), pos.getX(), pos.getY(), pos.getZ(), yaw, pitch));
    }

    public String[] getGroups() {
        return this.plugin.getPermissionsResolver().getGroups((OfflinePlayer)this.player);
    }

    public BlockBag getInventoryBlockBag() {
        return new BukkitPlayerBlockBag(this.player);
    }

    public GameMode getGameMode() {
        return GameModes.get((String)this.player.getGameMode().name().toLowerCase());
    }

    public void setGameMode(GameMode gameMode) {
        this.player.setGameMode(org.bukkit.GameMode.valueOf((String)gameMode.getId().toUpperCase()));
    }

    public boolean hasPermission(String perm) {
        return !this.plugin.getLocalConfiguration().noOpPermissions && this.player.isOp() || this.plugin.getPermissionsResolver().hasPermission(this.player.getWorld().getName(), (OfflinePlayer)this.player, perm);
    }

    public World getWorld() {
        return BukkitAdapter.adapt(this.player.getWorld());
    }

    public void dispatchCUIEvent(CUIEvent event) {
        String[] params = event.getParameters();
        String send = event.getTypeId();
        if (params.length > 0) {
            send = send + "|" + StringUtil.joinString((String[])params, (String)"|");
        }
        this.player.sendPluginMessage((Plugin)this.plugin, "worldedit:cui", send.getBytes(CUIChannelListener.UTF_8_CHARSET));
    }

    public Player getPlayer() {
        return this.player;
    }

    public void floatAt(int x, int y, int z, boolean alwaysGlass) {
        if (alwaysGlass || !this.player.getAllowFlight()) {
            super.floatAt(x, y, z, alwaysGlass);
            return;
        }
        this.setPosition(Vector3.at((double)((double)x + 0.5), (double)y, (double)((double)z + 0.5)));
        this.player.setFlying(true);
    }

    public BaseEntity getState() {
        throw new UnsupportedOperationException("Cannot create a state from this object");
    }

    public com.sk89q.worldedit.util.Location getLocation() {
        Location nativeLocation = this.player.getLocation();
        Vector3 position = BukkitAdapter.asVector(nativeLocation);
        return new com.sk89q.worldedit.util.Location((Extent)this.getWorld(), position, nativeLocation.getYaw(), nativeLocation.getPitch());
    }

    public boolean setLocation(com.sk89q.worldedit.util.Location location) {
        return this.player.teleport(BukkitAdapter.adapt(location));
    }

    @Nullable
    public <T> T getFacet(Class<? extends T> cls) {
        return null;
    }

    public SessionKey getSessionKey() {
        return new SessionKeyImpl(this.player.getUniqueId(), this.player.getName());
    }

    public <B extends BlockStateHolder<B>> void sendFakeBlock(BlockVector3 pos, B block) {
        Location loc = new Location(this.player.getWorld(), (double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        if (block == null) {
            this.player.sendBlockChange(loc, this.player.getWorld().getBlockAt(loc).getBlockData());
        } else {
            BukkitImplAdapter adapter;
            this.player.sendBlockChange(loc, BukkitAdapter.adapt(block));
            if (block instanceof BaseBlock && ((BaseBlock)block).hasNbtData() && (adapter = WorldEditPlugin.getInstance().getBukkitImplAdapter()) != null) {
                adapter.sendFakeNBT(this.player, pos, ((BaseBlock)block).getNbtData());
                if (block.getBlockType() == BlockTypes.STRUCTURE_BLOCK) {
                    adapter.sendFakeOP(this.player);
                }
            }
        }
    }

    private static class SessionKeyImpl
    implements SessionKey {
        private final UUID uuid;
        private final String name;

        private SessionKeyImpl(UUID uuid, String name) {
            this.uuid = uuid;
            this.name = name;
        }

        public UUID getUniqueId() {
            return this.uuid;
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        public boolean isActive() {
            return Bukkit.getServer().getPlayer(this.uuid) != null;
        }

        public boolean isPersistent() {
            return true;
        }
    }
}

