/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit;

import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.bukkit.adapter.BukkitImplAdapter;
import com.sk89q.worldedit.world.biome.BaseBiome;
import com.sk89q.worldedit.world.biome.BiomeData;
import com.sk89q.worldedit.world.registry.BiomeRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.block.Biome;

class BukkitBiomeRegistry
implements BiomeRegistry {
    BukkitBiomeRegistry() {
    }

    @Nullable
    public BaseBiome createFromId(int id) {
        return new BaseBiome(id);
    }

    public List<BaseBiome> getBiomes() {
        BukkitImplAdapter adapter = WorldEditPlugin.getInstance().getBukkitImplAdapter();
        if (adapter != null) {
            ArrayList<BaseBiome> biomes = new ArrayList<BaseBiome>();
            for (Biome biome : Biome.values()) {
                int biomeId = adapter.getBiomeId(biome);
                biomes.add(new BaseBiome(biomeId));
            }
            return biomes;
        }
        return Collections.emptyList();
    }

    @Nullable
    public BiomeData getData(BaseBiome biome) {
        BukkitImplAdapter adapter = WorldEditPlugin.getInstance().getBukkitImplAdapter();
        if (adapter != null) {
            Biome bukkitBiome = adapter.getBiome(biome.getId());
            return () -> bukkitBiome.name();
        }
        return null;
    }
}

