/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit;

import com.sk89q.minecraft.util.commands.CommandLocals;
import com.sk89q.util.StringUtil;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.session.SessionOwner;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.command.CommandMapping;
import com.sk89q.worldedit.world.World;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerCommandSendEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;

public class WorldEditListener
implements Listener {
    private WorldEditPlugin plugin;

    public WorldEditListener(WorldEditPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onGamemode(PlayerGameModeChangeEvent event) {
        if (!this.plugin.getInternalPlatform().isHookingEvents()) {
            return;
        }
        WorldEdit.getInstance().getSessionManager().get((SessionOwner)this.plugin.wrapPlayer(event.getPlayer()));
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        String newMessage;
        String[] split = event.getMessage().split(" ");
        if (split.length > 0) {
            split[0] = split[0].substring(1);
            split = this.plugin.getWorldEdit().getPlatformManager().getCommandManager().commandDetection(split);
        }
        if (!(newMessage = "/" + StringUtil.joinString((String[])split, (String)" ")).equals(event.getMessage())) {
            event.setMessage(newMessage);
            this.plugin.getServer().getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                if (!event.getMessage().isEmpty()) {
                    this.plugin.getServer().dispatchCommand((CommandSender)event.getPlayer(), event.getMessage().substring(1));
                }
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerCommand(PlayerCommandSendEvent event) {
        CommandLocals locals = new CommandLocals();
        locals.put(Actor.class, (Object)this.plugin.wrapCommandSender((CommandSender)event.getPlayer()));
        Set toRemove = this.plugin.getWorldEdit().getPlatformManager().getCommandManager().getDispatcher().getCommands().stream().filter(commandMapping -> !commandMapping.getCallable().testPermission(locals)).map(CommandMapping::getPrimaryAlias).collect(Collectors.toSet());
        event.getCommands().removeIf(toRemove::contains);
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!this.plugin.getInternalPlatform().isHookingEvents()) {
            return;
        }
        if (event.useItemInHand() == Event.Result.DENY) {
            return;
        }
        try {
            if (event.getHand() == EquipmentSlot.OFF_HAND) {
                return;
            }
        }
        catch (NoSuchFieldError | NoSuchMethodError incompatibleClassChangeError) {
            // empty catch block
        }
        BukkitPlayer player = this.plugin.wrapPlayer(event.getPlayer());
        World world = player.getWorld();
        WorldEdit we = this.plugin.getWorldEdit();
        Action action = event.getAction();
        if (action == Action.LEFT_CLICK_BLOCK) {
            Block clickedBlock = event.getClickedBlock();
            Location pos = new Location((Extent)world, (double)clickedBlock.getX(), (double)clickedBlock.getY(), (double)clickedBlock.getZ());
            if (we.handleBlockLeftClick((Player)player, pos)) {
                event.setCancelled(true);
            }
            if (we.handleArmSwing((Player)player)) {
                event.setCancelled(true);
            }
        } else if (action == Action.LEFT_CLICK_AIR) {
            if (we.handleArmSwing((Player)player)) {
                event.setCancelled(true);
            }
        } else if (action == Action.RIGHT_CLICK_BLOCK) {
            Block clickedBlock = event.getClickedBlock();
            Location pos = new Location((Extent)world, (double)clickedBlock.getX(), (double)clickedBlock.getY(), (double)clickedBlock.getZ());
            if (we.handleBlockRightClick((Player)player, pos)) {
                event.setCancelled(true);
            }
            if (we.handleRightClick((Player)player)) {
                event.setCancelled(true);
            }
        } else if (action == Action.RIGHT_CLICK_AIR && we.handleRightClick((Player)player)) {
            event.setCancelled(true);
        }
    }
}

