/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit;

public class BukkitImplementationTester {
    private static final String implementationMessage = "************************************************* Note: PaperMC (https://papermc.io/) is       ** recommended for optimal performance with     ** WorldEdit, WorldGuard, or CraftBook.         *************************************************";
    private static BukkitImplementation implementation;

    private BukkitImplementationTester() {
    }

    public static BukkitImplementation getImplementation() {
        if (implementation == null) {
            try {
                Class.forName("com.destroystokyo.paper.PaperConfig");
                implementation = BukkitImplementation.PAPER;
            }
            catch (Exception e) {
                try {
                    Class.forName("org.spigotmc.SpigotConfig");
                    implementation = BukkitImplementation.SPIGOT;
                }
                catch (Exception e2) {
                    implementation = BukkitImplementation.CRAFTBUKKIT;
                }
            }
            if (implementation != BukkitImplementation.PAPER) {
                // empty if block
            }
        }
        return implementation;
    }

    public static boolean isSpigotCompatible() {
        return BukkitImplementationTester.getImplementation() == BukkitImplementation.SPIGOT || BukkitImplementationTester.getImplementation() == BukkitImplementation.PAPER;
    }

    public static boolean isPaperCompatible() {
        return BukkitImplementationTester.getImplementation() == BukkitImplementation.PAPER;
    }

    public static enum BukkitImplementation {
        CRAFTBUKKIT,
        SPIGOT,
        PAPER;

    }
}

