/*
 * Decompiled with CFR 0.152.
 */
package me.wolfyscript.utilities.api.utils.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import me.wolfyscript.utilities.api.WolfyUtilities;
import org.bukkit.Bukkit;
import org.bukkit.scheduler.BukkitRunnable;

public class SQLDataBase {
    private WolfyUtilities api;
    private Connection connection;
    private String host;
    private String database;
    private String username;
    private String password;
    private int port;

    public SQLDataBase(WolfyUtilities api, String host, String database, String username, String password, int port) {
        this.api = api;
        this.host = host;
        this.database = database;
        this.username = username;
        this.password = password;
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openConnectionOnMainThread() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                return;
            }
            SQLDataBase sQLDataBase = this;
            synchronized (sQLDataBase) {
                if (this.connection != null && !this.connection.isClosed()) {
                    return;
                }
                Class.forName("com.mysql.jdbc.Driver");
                this.connection = DriverManager.getConnection("jdbc:mysql://" + this.host + ":" + this.port + "/" + this.database, this.username, this.password);
                this.api.sendConsoleMessage("Connected to MySQL DataBase");
            }
        }
        catch (ClassNotFoundException | SQLException e) {
            e.printStackTrace();
        }
    }

    public void openConnectionAsync() {
        BukkitRunnable runnable = new BukkitRunnable(){

            public void run() {
                SQLDataBase.this.openConnectionOnMainThread();
            }
        };
        runnable.runTaskAsynchronously(this.api.getPlugin());
    }

    public void openConnection() {
        this.openConnectionAsync();
    }

    public void executeUpdate(PreparedStatement preparedStatement) {
        this.executeUpdate(preparedStatement, true);
    }

    public void executeUpdate(PreparedStatement preparedStatement, boolean async) {
        if (async) {
            Bukkit.getScheduler().runTaskAsynchronously(this.api.getPlugin(), () -> {
                try {
                    preparedStatement.executeUpdate();
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    this.api.sendConsoleWarning("Failed to execute SQL Query! " + e.getMessage());
                }
            });
        } else {
            try {
                preparedStatement.executeUpdate();
                preparedStatement.close();
            }
            catch (SQLException e) {
                this.api.sendConsoleWarning("Failed to execute SQL Query! " + e.getMessage());
            }
        }
    }

    public void executeUpdate(String query) {
        this.executeUpdate(query, false);
    }

    public void executeUpdate(String query, boolean async) {
        try {
            this.executeUpdate(this.connection.prepareStatement(query), async);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public PreparedStatement getPreparedStatement(String query) throws SQLException {
        return this.connection.prepareStatement(query);
    }

    public ResultSet getResultSet(PreparedStatement preparedStatement) throws SQLException {
        return preparedStatement.executeQuery();
    }

    public ResultSet getResultSet(String query) throws SQLException {
        return this.getResultSet(this.getPreparedStatement(query));
    }

    public Connection getConnection() {
        return this.connection;
    }

    public WolfyUtilities getApi() {
        return this.api;
    }
}

