/*
 * Decompiled with CFR 0.152.
 */
package me.wolfyscript.utilities.api.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.wolfyscript.utilities.api.WolfyUtilities;
import me.wolfyscript.utilities.api.config.ConfigAPI;
import me.wolfyscript.utilities.api.config.Configuration;
import me.wolfyscript.utilities.api.config.FileConfiguration;
import me.wolfyscript.utilities.main.Main;
import org.bukkit.Bukkit;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class YamlConfiguration
extends FileConfiguration {
    private org.bukkit.configuration.file.YamlConfiguration config;
    private int intervalsToPass = 0;
    private int passedIntervals;
    private boolean firstInit = false;

    public YamlConfiguration(ConfigAPI configAPI, String path, String name, String defPath, String defFileName, boolean override) {
        super(configAPI, path, name, defPath, defFileName, Configuration.Type.YAML);
        if (override && this.configFile.exists() && !this.configFile.delete()) {
            Main.getMainUtil().sendConsoleMessage("Error while trying to override YamlConfiguration!");
            Main.getMainUtil().sendConsoleMessage("File: " + this.configFile.getPath());
        }
        if (!this.configFile.exists()) {
            this.firstInit = true;
            try {
                this.configFile.getParentFile().mkdirs();
                this.configFile.createNewFile();
            }
            catch (IOException e) {
                Main.getMainUtil().sendConsoleMessage("Error creating file: " + this.configFile.getPath());
                Main.getMainUtil().sendConsoleMessage("     cause: " + e.getMessage());
            }
        }
        this.config = org.bukkit.configuration.file.YamlConfiguration.loadConfiguration((File)this.configFile);
        if (this.firstInit) {
            this.loadDefaults();
            this.onFirstInit();
            this.firstInit = false;
        }
        this.init();
    }

    public YamlConfiguration(ConfigAPI configAPI, String defaultPath, String defaultName, String savePath, String name) {
        this(configAPI, savePath, name, defaultPath, defaultName, false);
    }

    public YamlConfiguration(ConfigAPI configAPI, String defaultPath, String savePath, String name) {
        this(configAPI, defaultPath, name, savePath, name);
    }

    public YamlConfiguration(ConfigAPI configAPI, String defaultPath, String savePath, String name, boolean override) {
        this(configAPI, defaultPath, name, savePath, name, override);
    }

    public YamlConfiguration(ConfigAPI configAPI, String savePath, String name) {
        this(configAPI, "", savePath, name);
    }

    public YamlConfiguration(ConfigAPI configAPI, String savePath, String name, boolean override) {
        this(configAPI, "", savePath, name, override);
    }

    public YamlConfiguration(ConfigAPI configAPI, String name) {
        this(configAPI, configAPI.getPlugin().getDataFolder().getPath(), name);
    }

    public YamlConfiguration(ConfigAPI configAPI, String name, boolean override) {
        this(configAPI, configAPI.getPlugin().getDataFolder().getPath(), name, override);
    }

    @Override
    public void onFirstInit() {
    }

    @Override
    public void init() {
    }

    public boolean isFirstInit() {
        return this.firstInit;
    }

    public void setIntervalsToPass(int intervalsToPass) {
        this.intervalsToPass = intervalsToPass;
    }

    @Override
    public void loadDefaults() {
        this.config.options().copyDefaults(true);
        try {
            String fileName = this.defFileName.isEmpty() ? this.getName() : this.defFileName;
            InputStream inputStream = this.plugin.getResource(this.defPath.isEmpty() ? fileName : this.defPath + "/" + fileName + ".yml");
            if (inputStream != null) {
                InputStreamReader stream = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
                org.bukkit.configuration.file.YamlConfiguration defConfig = org.bukkit.configuration.file.YamlConfiguration.loadConfiguration((Reader)stream);
                this.config.options().header(defConfig.options().header());
                this.config.setDefaults((Configuration)defConfig);
                ((Reader)stream).close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.reload();
    }

    @Override
    public void reload() {
        this.save();
        this.load();
    }

    void reloadAuto() {
        if (this.intervalsToPass > 0) {
            if (this.passedIntervals < this.intervalsToPass) {
                ++this.passedIntervals;
            } else {
                this.reload();
            }
        } else {
            this.reload();
        }
    }

    @Override
    public void save() {
        try {
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void load() {
        try {
            this.config.load(this.configFile);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void set(String path, Object object) {
        this.config.set(path, object);
        if (this.saveAfterValueSet) {
            this.reload();
        }
    }

    @Override
    public Object get(String path) {
        return this.config.get(path);
    }

    @Override
    public Object get(String path, Object def) {
        return this.config.get(path, def);
    }

    public org.bukkit.configuration.file.FileConfiguration getConfig() {
        return this.config;
    }

    @Override
    public Configuration.Type getType() {
        return Configuration.Type.YAML;
    }

    @Override
    public Set<String> getKeys() {
        return this.getKeys(false);
    }

    @Override
    public Set<String> getKeys(boolean deep) {
        return this.config.getKeys(deep);
    }

    @Override
    public Map<String, Object> getMap() {
        return this.config.getValues(false);
    }

    @Override
    public boolean hasPathSeparator() {
        return this.config.options().pathSeparator() != '\u0000';
    }

    @Override
    public void setPathSeparator(char pathSeparator) {
        this.config.options().pathSeparator(pathSeparator);
    }

    @Override
    public char getPathSeparator() {
        return this.config.options().pathSeparator();
    }

    public Object getObject(String path) {
        return this.config.get(path);
    }

    @Override
    public String getString(String path) {
        return this.config.getString(path);
    }

    @Override
    public String getString(String path, String def) {
        return this.config.getString(path, def);
    }

    @Override
    public int getInt(String path) {
        return this.config.getInt(path);
    }

    @Override
    public int getInt(String path, int def) {
        return this.config.getInt(path, def);
    }

    @Override
    public boolean getBoolean(String path) {
        return this.config.getBoolean(path);
    }

    @Override
    public long getLong(String path) {
        return this.config.getLong(path);
    }

    @Override
    public long getLong(String path, long def) {
        return this.config.getLong(path, def);
    }

    @Override
    public double getDouble(String path) {
        return this.config.getDouble(path);
    }

    @Override
    public double getDouble(String path, double def) {
        return this.config.getDouble(path, def);
    }

    @Override
    public List<?> getList(String path) {
        return this.config.getList(path);
    }

    @Override
    @Nonnull
    public List<String> getStringList(String path) {
        return this.config.getStringList(path);
    }

    @Override
    @Deprecated
    public void saveItem(String path, String name, ItemStack itemStack) {
        this.setItem(path, name, itemStack);
    }

    @Override
    @Deprecated
    public void saveItem(String path, ItemStack item) {
        this.setItem(path, item);
    }

    @Override
    public void setItem(String path, ItemStack itemStack) {
        if (itemStack.hasItemMeta()) {
            ItemMeta itemMeta = itemStack.getItemMeta();
            if (itemMeta.hasDisplayName()) {
                itemMeta.setDisplayName(itemMeta.getDisplayName().replace('\u00a7', '&'));
            }
            if (itemMeta.hasLore()) {
                ArrayList<String> newLore = new ArrayList<String>();
                for (String row : itemMeta.getLore()) {
                    newLore.add(row.replace('\u00a7', '&'));
                }
                itemMeta.setLore(newLore);
            }
            itemStack.setItemMeta(itemMeta);
        }
        this.set(path, itemStack.serialize());
    }

    @Override
    public void setItem(String path, String name, ItemStack itemStack) {
        this.setItem(path + "." + name, itemStack);
    }

    @Override
    public ItemStack getItem(String path) {
        return this.getItem(path, true);
    }

    @Override
    @Nullable
    public ItemStack getItem(String path, boolean replaceKeys) {
        if (this.config.isSet(path)) {
            Map<String, Object> data = this.getValues(path);
            data.put("v", Bukkit.getUnsafe().getDataVersion());
            ItemStack itemStack = ItemStack.deserialize(data);
            if (itemStack.hasItemMeta()) {
                ItemMeta itemMeta = itemStack.getItemMeta();
                if (itemMeta.hasDisplayName()) {
                    String displayName = itemMeta.getDisplayName();
                    if (replaceKeys && this.api.getLanguageAPI().getActiveLanguage() != null) {
                        displayName = this.api.getLanguageAPI().getActiveLanguage().replaceKeys(displayName);
                    }
                    itemMeta.setDisplayName(WolfyUtilities.translateColorCodes(displayName));
                }
                if (itemMeta.hasLore()) {
                    ArrayList<String> newLore = new ArrayList<String>();
                    for (String row : itemMeta.getLore()) {
                        if (replaceKeys && this.api.getLanguageAPI().getActiveLanguage() != null) {
                            if (row.startsWith("[WU]")) {
                                row = row.substring("[WU]".length());
                                row = this.api.getLanguageAPI().getActiveLanguage().replaceKeys(row);
                            } else if (row.startsWith("[WU!]")) {
                                List<String> rows = this.api.getLanguageAPI().getActiveLanguage().replaceKey(row.substring("[WU!]".length()));
                                for (String newRow : rows) {
                                    newLore.add(WolfyUtilities.translateColorCodes(newRow));
                                }
                                continue;
                            }
                        }
                        newLore.add(WolfyUtilities.translateColorCodes(row));
                    }
                    itemMeta.setLore(newLore);
                }
                itemStack.setItemMeta(itemMeta);
            }
            return itemStack;
        }
        return null;
    }

    @Override
    public Map<String, Object> getValues(String path) {
        if (this.config.getConfigurationSection(path) != null) {
            return this.config.getConfigurationSection(path).getValues(false);
        }
        return new HashMap<String, Object>();
    }

    public org.bukkit.configuration.file.YamlConfiguration getBukkitConfig() {
        return this.config;
    }
}

