/*
 * Decompiled with CFR 0.152.
 */
package me.wolfyscript.utilities.api.inventory.button.buttons;

import java.util.HashMap;
import javax.annotation.Nonnull;
import me.wolfyscript.utilities.api.WolfyUtilities;
import me.wolfyscript.utilities.api.inventory.GuiHandler;
import me.wolfyscript.utilities.api.inventory.GuiWindow;
import me.wolfyscript.utilities.api.inventory.button.Button;
import me.wolfyscript.utilities.api.inventory.button.ButtonState;
import me.wolfyscript.utilities.api.inventory.button.ButtonType;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;

public class ToggleButton
extends Button {
    private ButtonState[] states;
    private boolean defaultState;
    private HashMap<GuiHandler, Boolean> settings;

    public ToggleButton(String id, boolean defaultState, @Nonnull ButtonState state, @Nonnull ButtonState state2) {
        super(id, ButtonType.TOGGLE);
        this.defaultState = defaultState;
        this.states = new ButtonState[]{state, state2};
        this.settings = new HashMap();
    }

    public ToggleButton(String id, @Nonnull ButtonState state, @Nonnull ButtonState state2) {
        this(id, false, state, state2);
    }

    public void setState(GuiHandler guiHandler, boolean enabled) {
        this.settings.put(guiHandler, enabled);
    }

    @Override
    public void init(GuiWindow guiWindow) {
        this.states[0].init(guiWindow);
        this.states[1].init(guiWindow);
    }

    @Override
    public void init(String windowKey, WolfyUtilities api) {
        this.states[0].init(windowKey, api);
        this.states[1].init(windowKey, api);
    }

    @Override
    public boolean execute(GuiHandler guiHandler, Player player, Inventory inventory, int slot, InventoryClickEvent event) {
        boolean result = this.states[this.settings.getOrDefault(guiHandler, this.defaultState) != false ? 0 : 1].getAction().run(guiHandler, player, inventory, slot, event);
        this.settings.put(guiHandler, this.settings.getOrDefault(guiHandler, this.defaultState) == false);
        return result;
    }

    @Override
    public void render(GuiHandler guiHandler, Player player, Inventory inventory, int slot, boolean help) {
        this.applyItem(guiHandler, player, inventory, this.states[this.settings.getOrDefault(guiHandler, this.defaultState) != false ? 0 : 1], slot, help);
    }
}

