/*
 * Decompiled with CFR 0.152.
 */
package me.wolfyscript.utilities.api.inventory;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import me.wolfyscript.utilities.api.WolfyUtilities;
import me.wolfyscript.utilities.api.inventory.GuiHandler;
import me.wolfyscript.utilities.api.inventory.GuiWindow;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.inventory.DragType;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;

public class GuiItemDragEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private boolean cancelled = false;
    private GuiHandler guiHandler;
    private Player player;
    private WolfyUtilities wolfyUtilities;
    private GuiWindow guiWindow;
    private final DragType type;
    private final Map<Integer, ItemStack> addedItems;
    private final Set<Integer> containerSlots;
    private final ItemStack oldCursor;
    private ItemStack newCursor;
    private InventoryView view;

    public GuiItemDragEvent(GuiHandler guiHandler, InventoryDragEvent event) {
        this.guiHandler = guiHandler;
        this.player = guiHandler.getPlayer();
        this.wolfyUtilities = guiHandler.getApi();
        this.guiWindow = guiHandler.getCurrentInv();
        this.type = event.getType();
        this.addedItems = event.getNewItems();
        this.containerSlots = event.getInventorySlots();
        this.oldCursor = event.getOldCursor();
        this.view = event.getView();
    }

    public InventoryView getView() {
        return this.view;
    }

    public boolean verify(GuiWindow guiWindow) {
        return guiWindow.equals(this.guiWindow);
    }

    public GuiWindow getGuiWindow() {
        return this.guiWindow;
    }

    public WolfyUtilities getWolfyUtilities() {
        return this.wolfyUtilities;
    }

    public Player getPlayer() {
        return this.player;
    }

    public GuiHandler getGuiHandler() {
        return this.guiHandler;
    }

    public Map<Integer, ItemStack> getNewItems() {
        return Collections.unmodifiableMap(this.addedItems);
    }

    public Set<Integer> getRawSlots() {
        return this.addedItems.keySet();
    }

    public Set<Integer> getInventorySlots() {
        return this.containerSlots;
    }

    public ItemStack getCursor() {
        return this.newCursor;
    }

    public void setCursor(ItemStack newCursor) {
        this.newCursor = newCursor;
    }

    public ItemStack getOldCursor() {
        return this.oldCursor.clone();
    }

    public DragType getType() {
        return this.type;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }
}

