/*
 * Decompiled with CFR 0.152.
 */
package me.wolfyscript.utilities.api.utils;

import com.google.common.base.Preconditions;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class NamespacedKey
implements Comparable<NamespacedKey> {
    private static final Pattern VALID_NAMESPACE = Pattern.compile("[a-z0-9._-]+");
    private static final Pattern VALID_KEY = Pattern.compile("[a-z0-9/._-]+");
    private final String namespace;
    private final String key;

    public NamespacedKey(String namespace, String key) {
        Preconditions.checkArgument((namespace != null && VALID_NAMESPACE.matcher(namespace).matches() ? 1 : 0) != 0, (String)"Invalid namespace. Must be [a-z0-9._-]: %s", (Object)namespace);
        Preconditions.checkArgument((key != null && VALID_KEY.matcher(key).matches() ? 1 : 0) != 0, (String)"Invalid key. Must be [a-z0-9/._-]: %s", (Object)key);
        this.namespace = namespace;
        this.key = key;
        String string = this.toString();
        Preconditions.checkArgument((string.length() < 256 ? 1 : 0) != 0, (String)"NamespacedKey must be less than 256 characters", (Object)string);
    }

    public NamespacedKey(@NotNull Plugin plugin, @NotNull String key) {
        Preconditions.checkArgument((plugin != null ? 1 : 0) != 0, (Object)"Plugin cannot be null");
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Key cannot be null");
        this.namespace = plugin.getName().toLowerCase(Locale.ROOT);
        this.key = key.toLowerCase(Locale.ROOT);
        Preconditions.checkArgument((boolean)VALID_NAMESPACE.matcher(this.namespace).matches(), (String)"Invalid namespace. Must be [a-z0-9._-]: %s", (Object)this.namespace);
        Preconditions.checkArgument((boolean)VALID_KEY.matcher(this.key).matches(), (String)"Invalid key. Must be [a-z0-9/._-]: %s", (Object)this.key);
        String string = this.toString();
        Preconditions.checkArgument((string.length() < 256 ? 1 : 0) != 0, (String)"NamespacedKey must be less than 256 characters (%s)", (Object)string);
    }

    @Nonnull
    public String getNamespace() {
        return this.namespace;
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NamespacedKey other = (NamespacedKey)obj;
        return this.namespace.equals(other.namespace) && this.key.equals(other.key);
    }

    public int hashCode() {
        int hash = 3;
        hash = 47 * hash + this.namespace.hashCode();
        hash = 47 * hash + this.key.hashCode();
        return hash;
    }

    public String toString() {
        return this.namespace + ":" + this.key;
    }

    @Override
    public int compareTo(@NotNull NamespacedKey namespacedKey) {
        int namepsaceDifference = this.getNamespace().compareTo(namespacedKey.getNamespace());
        return namepsaceDifference == 0 ? this.getKey().compareTo(namespacedKey.getKey()) : namepsaceDifference;
    }
}

