/*
 * Decompiled with CFR 0.152.
 */
package me.wolfyscript.utilities.api.custom_items;

import java.util.Locale;
import me.wolfyscript.utilities.api.config.ConfigAPI;
import me.wolfyscript.utilities.api.config.JsonConfiguration;
import me.wolfyscript.utilities.api.custom_items.CustomItem;
import me.wolfyscript.utilities.api.custom_items.CustomItems;
import me.wolfyscript.utilities.api.utils.NamespacedKey;
import org.bukkit.Material;

public class CustomConfig
extends JsonConfiguration {
    private String namespace;
    private String id;
    private NamespacedKey namespacedKey;

    public CustomConfig(ConfigAPI configAPI, String namespace, String name, String path, String defaultPath, String defaultName, boolean override) {
        super(configAPI, path, name, defaultPath, defaultName, override);
        this.namespace = namespace;
        this.namespacedKey = new NamespacedKey(namespace, name);
        this.id = namespace + ":" + name;
        this.setPathSeparator('.');
    }

    public CustomConfig(String jsonData, ConfigAPI configAPI, String namespace, String name, String defaultPath, String defaultName) {
        super(jsonData, configAPI, name, defaultPath, defaultName);
        this.namespace = namespace;
        this.namespacedKey = new NamespacedKey(namespace, name);
        this.id = namespace + ":" + name;
        this.setPathSeparator('.');
    }

    public CustomConfig(ConfigAPI configAPI, String namespace, String name, String defaultPath, String defaultName) {
        super(configAPI, name, defaultPath, defaultName);
        this.namespace = namespace;
        this.namespacedKey = namespace.isEmpty() || name.isEmpty() ? null : new NamespacedKey(namespace, name);
        this.id = namespace + ":" + name;
        this.setPathSeparator('.');
    }

    public CustomConfig(ConfigAPI configAPI, String defaultPath, String defaultName) {
        super(configAPI, "", defaultPath, defaultName);
        this.namespace = "";
        this.namespacedKey = null;
        this.id = "";
        this.setPathSeparator('.');
    }

    @Deprecated
    public CustomConfig(ConfigAPI configAPI, String namespace, String name, String path, String defaultPath, String defaultName, boolean override, String fileType) {
        this(configAPI, namespace, name, path, defaultPath, defaultName, override);
    }

    public NamespacedKey getNamespacedKey() {
        return this.namespacedKey;
    }

    @Deprecated
    public String getNamespace() {
        return this.namespace;
    }

    @Deprecated
    public String getId() {
        return this.id;
    }

    public void saveCustomItem(String path, CustomItem customItem) {
        if (customItem != null) {
            if (customItem.getNamespacedKey() != null) {
                this.set(path + ".item_key", customItem.getNamespacedKey().toString());
                this.set(path + ".custom_amount", customItem.getAmount() != CustomItems.getCustomItem(customItem.getNamespacedKey()).getAmount() ? customItem.getAmount() : 0);
            } else {
                this.setItem(path + ".item", customItem.getItemStack());
            }
        } else {
            this.setItem(path + ".item", null);
        }
    }

    public CustomItem getCustomItem(String path) {
        String id = this.getString(path + ".item_key");
        if (id != null && !id.isEmpty()) {
            CustomItem customItem = CustomItems.getCustomItem(new NamespacedKey(id.split(":")[0].toLowerCase(Locale.ROOT), id.split(":")[1].toLowerCase(Locale.ROOT)));
            int i = this.getInt(path + ".custom_amount");
            if (i != 0) {
                customItem.setAmount(i);
            }
            return customItem;
        }
        if (this.getItem(path + ".item") != null) {
            return new CustomItem(this.getItem(path + ".item"));
        }
        return new CustomItem(Material.AIR);
    }

    public void linkToFile(NamespacedKey namespacedKey, String path) {
        this.namespace = namespacedKey.getNamespace();
        this.setName(namespacedKey.getKey());
        this.id = namespacedKey.getNamespace() + ":" + namespacedKey.getKey();
        this.namespacedKey = namespacedKey;
        this.linkToFile(path + "/" + namespacedKey.getKey());
    }

    @Deprecated
    public void linkToFile(String namespace, String name, String path) {
        this.namespace = namespace;
        this.setName(name);
        this.id = namespace + ":" + name;
        this.namespacedKey = new NamespacedKey(namespace, name);
        this.linkToFile(path + "/" + name);
    }
}

