/*
 * Decompiled with CFR 0.152.
 */
package me.wolfyscript.utilities.api.language;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.wolfyscript.utilities.api.WolfyUtilities;
import me.wolfyscript.utilities.api.config.ConfigAPI;
import me.wolfyscript.utilities.api.config.MemoryConfiguration;

public class Language {
    private String lang;
    private MemoryConfiguration config;
    private HashMap<String, Object> messages;

    public Language(String lang, MemoryConfiguration config, ConfigAPI configAPI) {
        this.lang = lang;
        this.config = config;
        this.messages = new HashMap();
        configAPI.registerConfig(config);
        this.reloadKeys();
    }

    public String replaceKeys(String msg) {
        ArrayList<String> keys = new ArrayList<String>();
        Pattern pattern = Pattern.compile("[$]([a-zA-Z0-9._]*?)[$]");
        Matcher matcher = pattern.matcher(msg);
        while (matcher.find()) {
            keys.add(matcher.group(0));
        }
        for (String key : keys) {
            Object object = this.messages.get(key.replace("$", ""));
            if (object instanceof String) {
                msg = msg.replace(key, (String)object);
                continue;
            }
            if (!(object instanceof List)) continue;
            StringBuilder sB = new StringBuilder();
            List list = (List)object;
            list.forEach(s -> sB.append(' ').append((String)s));
            msg = msg.replace(key, sB.toString());
        }
        return msg;
    }

    public List<String> replaceKeys(List<String> msg) {
        Pattern pattern = Pattern.compile("[$]([a-zA-Z0-9._]*?)[$]");
        ArrayList<String> result = new ArrayList<String>();
        msg.forEach(s -> {
            ArrayList<String> keys = new ArrayList<String>();
            Matcher matcher = pattern.matcher((CharSequence)s);
            while (matcher.find()) {
                keys.add(matcher.group(0));
            }
            if (keys.size() > 1) {
                for (String key : keys) {
                    Object object = this.messages.get(key.replace("$", ""));
                    if (object instanceof String) {
                        result.add(WolfyUtilities.translateColorCodes(s.replace(key, (String)object)));
                        continue;
                    }
                    if (!(object instanceof List)) continue;
                    StringBuilder sB = new StringBuilder();
                    List list = (List)object;
                    list.forEach(translatedS -> sB.append(' ').append((String)translatedS));
                    result.add(WolfyUtilities.translateColorCodes(s.replace(key, sB.toString())));
                }
            } else {
                String key = (String)keys.get(0);
                Object object = this.messages.get(key.replace("$", ""));
                if (object instanceof String) {
                    result.add(WolfyUtilities.translateColorCodes(s.replace(key, (String)object)));
                } else if (object instanceof List) {
                    List list = (List)object;
                    result.addAll(list.stream().map(s1 -> WolfyUtilities.translateColorCodes(s1)).collect(Collectors.toList()));
                }
            }
        });
        return result;
    }

    public String replaceColoredKeys(String msg) {
        return WolfyUtilities.translateColorCodes(this.replaceKeys(msg));
    }

    public List<String> replaceKeys(String ... msg) {
        List<String> list = Arrays.asList(msg);
        for (int i = 0; i < msg.length; ++i) {
            list.set(i, this.replaceKeys(msg[i]));
        }
        return list;
    }

    public List<String> replaceKey(String key) {
        ArrayList<String> message = new ArrayList<String>();
        if (key != null) {
            if (key.contains("$")) {
                key = key.replace("$", "");
            }
            if (this.messages.get(key) instanceof ArrayList) {
                message.addAll((ArrayList)this.messages.get(key));
            }
        }
        return message;
    }

    public MemoryConfiguration getConfig() {
        return this.config;
    }

    public void reloadKeys() {
        Set<String> keys = this.config.getKeys(true);
        for (String key : keys) {
            if (this.config.get(key) instanceof ArrayList) {
                this.messages.put(key, this.config.getStringList(key));
                continue;
            }
            this.messages.put(key, this.config.getString(key));
        }
    }

    public String getName() {
        return this.lang;
    }
}

