/*
 * Decompiled with CFR 0.152.
 */
package me.wolfyscript.utilities.api.utils.particles;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import me.wolfyscript.utilities.api.utils.NamespacedKey;
import me.wolfyscript.utilities.main.Main;
import me.wolfyscript.utilities.org.mozilla.javascript.Context;
import me.wolfyscript.utilities.org.mozilla.javascript.Function;
import me.wolfyscript.utilities.org.mozilla.javascript.Scriptable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;

public class Particle {
    private NamespacedKey namespacedKey;
    private Particle superParticle;
    private org.bukkit.Particle particle;
    private static Scriptable scope = Context.enter().initSafeStandardObjects();
    private Material icon;
    private Class<?> dataClass;
    private Object data;
    private Double relativeX;
    private Double relativeY;
    private Double relativeZ;
    private Double offsetX;
    private Double offsetY;
    private Double offsetZ;
    private Integer count;
    private Double extra;
    private List<String> scripts;
    private String name;
    private List<String> description;

    public Particle(Particle superParticle) {
        this.setSuperParticle(superParticle);
    }

    public Particle() {
    }

    public Particle(org.bukkit.Particle particle) {
        this(particle, null);
    }

    public Particle(org.bukkit.Particle particle, Object data) {
        this(particle, 1, 1.0, data);
    }

    public Particle(org.bukkit.Particle particle, int count) {
        this(particle, count, 1.0, null);
    }

    public Particle(org.bukkit.Particle particle, int count, Object data) {
        this(particle, count, 1.0, data);
    }

    public Particle(org.bukkit.Particle particle, int count, double extra) {
        this(particle, count, extra, null);
    }

    public Particle(org.bukkit.Particle particle, int count, double extra, Object data) {
        this(particle, 0.0, 0.0, 0.0, count, extra, data);
    }

    public Particle(org.bukkit.Particle particle, double relativeX, double relativeY, double relativeZ, int count) {
        this(particle, relativeX, relativeY, relativeZ, count, 1.0, null);
    }

    public Particle(org.bukkit.Particle particle, double relativeX, double relativeY, double relativeZ, int count, double extra) {
        this(particle, relativeX, relativeY, relativeZ, count, 1.0, extra);
    }

    public Particle(org.bukkit.Particle particle, double relativeX, double relativeY, double relativeZ, int count, Object data) {
        this(particle, relativeX, relativeY, relativeZ, count, 1.0, data);
    }

    public Particle(org.bukkit.Particle particle, double relativeX, double relativeY, double relativeZ, int count, double extra, Object data) {
        this(particle, relativeX, relativeY, relativeZ, count, 0.0, 0.0, 0.0, extra, data);
    }

    public Particle(org.bukkit.Particle particle, double relativeX, double relativeY, double relativeZ, int count, double offsetX, double offsetY, double offsetZ) {
        this(particle, relativeX, relativeY, relativeZ, count, offsetX, offsetY, offsetZ, 1.0, null);
    }

    public Particle(org.bukkit.Particle particle, double relativeX, double relativeY, double relativeZ, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this(particle, relativeX, relativeY, relativeZ, count, offsetX, offsetY, offsetZ, extra, null);
    }

    public Particle(org.bukkit.Particle particle, double relativeX, double relativeY, double relativeZ, int count, double offsetX, double offsetY, double offsetZ, Object data) {
        this(particle, relativeX, relativeY, relativeZ, count, offsetX, offsetY, offsetZ, 1.0, data);
    }

    public Particle(org.bukkit.Particle particle, double relativeX, double relativeY, double relativeZ, int count, double offsetX, double offsetY, double offsetZ, double extra, Object data) {
        this.particle = particle;
        this.dataClass = particle.getDataType();
        this.scripts = new ArrayList<String>();
        this.data = data;
        this.icon = Material.FIREWORK_STAR;
        this.relativeX = relativeX;
        this.relativeY = relativeY;
        this.relativeZ = relativeZ;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
        this.count = count;
        this.extra = extra;
    }

    public NamespacedKey getNamespacedKey() {
        return this.namespacedKey;
    }

    public void setNamespacedKey(NamespacedKey namespacedKey) {
        this.namespacedKey = namespacedKey;
    }

    public void setSuperParticle(Particle superParticle) {
        this.superParticle = superParticle;
    }

    public Particle getSuperParticle() {
        return this.superParticle;
    }

    public boolean hasSuperParticle() {
        return this.superParticle != null;
    }

    public org.bukkit.Particle getParticle() {
        return this.hasParticle() || !this.hasSuperParticle() ? this.particle : this.getSuperParticle().getParticle();
    }

    public void setParticle(org.bukkit.Particle particle) {
        this.particle = particle;
        this.dataClass = particle.getDataType();
    }

    public Object getData() {
        return this.hasData() || !this.hasSuperParticle() ? this.data : this.getSuperParticle().getData();
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Material getIcon() {
        return this.hasIcon() || !this.hasSuperParticle() ? this.icon : this.getSuperParticle().getIcon();
    }

    public void setIcon(Material icon) {
        this.icon = icon;
    }

    public String getName() {
        return this.hasName() || !this.hasSuperParticle() ? this.name : this.getSuperParticle().getName();
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getDescription() {
        return this.hasDescription() || !this.hasSuperParticle() ? this.description : this.getSuperParticle().getDescription();
    }

    public void setDescription(List<String> description) {
        this.description = description;
    }

    public Class<?> getDataClass() {
        return this.hasDataClass() || !this.hasSuperParticle() ? this.dataClass : this.getSuperParticle().getDataClass();
    }

    public Double getRelativeX() {
        return this.hasRelativeX() || !this.hasSuperParticle() ? this.relativeX : this.getSuperParticle().getRelativeX();
    }

    public void setRelativeX(double relativeX) {
        this.relativeX = relativeX;
    }

    public Double getRelativeY() {
        return this.hasRelativeY() || !this.hasSuperParticle() ? this.relativeY : this.getSuperParticle().getRelativeY();
    }

    public void setRelativeY(double relativeY) {
        this.relativeY = relativeY;
    }

    public Double getRelativeZ() {
        return this.hasRelativeZ() || !this.hasSuperParticle() ? this.relativeZ : this.getSuperParticle().getRelativeZ();
    }

    public void setRelativeZ(double relativeZ) {
        this.relativeZ = relativeZ;
    }

    public Double getOffsetX() {
        return this.hasOffsetX() || !this.hasSuperParticle() ? this.offsetX : this.getSuperParticle().getOffsetX();
    }

    public void setOffsetX(double offsetX) {
        this.offsetX = offsetX;
    }

    public Double getOffsetY() {
        return this.hasOffsetY() || !this.hasSuperParticle() ? this.offsetY : this.getSuperParticle().getOffsetY();
    }

    public void setOffsetY(double offsetY) {
        this.offsetY = offsetY;
    }

    public Double getOffsetZ() {
        return this.hasOffsetZ() || !this.hasSuperParticle() ? this.offsetZ : this.getSuperParticle().getOffsetZ();
    }

    public void setOffsetZ(double offsetZ) {
        this.offsetZ = offsetZ;
    }

    public Integer getCount() {
        return this.hasCount() || !this.hasSuperParticle() ? this.count : this.getSuperParticle().getCount();
    }

    public void setCount(int count) {
        this.count = count;
    }

    public Double getExtra() {
        return this.hasExtra() || !this.hasSuperParticle() ? this.extra : this.getSuperParticle().getExtra();
    }

    public void setExtra(double extra) {
        this.extra = extra;
    }

    public List<String> getScripts() {
        return this.hasScripts() || !this.hasSuperParticle() ? this.scripts : this.getSuperParticle().getScripts();
    }

    public boolean hasIcon() {
        return this.icon != null;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public boolean hasRelativeX() {
        return this.relativeX != null;
    }

    public boolean hasRelativeY() {
        return this.relativeY != null;
    }

    public boolean hasRelativeZ() {
        return this.relativeZ != null;
    }

    public boolean hasOffsetX() {
        return this.offsetX != null;
    }

    public boolean hasOffsetY() {
        return this.offsetY != null;
    }

    public boolean hasOffsetZ() {
        return this.offsetZ != null;
    }

    public boolean hasCount() {
        return this.count != null;
    }

    public boolean hasExtra() {
        return this.extra != null;
    }

    public boolean hasParticle() {
        return this.particle != null;
    }

    public boolean hasData() {
        return this.data != null;
    }

    public boolean hasDataClass() {
        return this.dataClass != null;
    }

    public boolean hasScripts() {
        return this.scripts != null;
    }

    public void addScript(String script) {
        if (this.scripts == null) {
            this.scripts = new ArrayList<String>();
        }
        this.scripts.add(script);
    }

    public String toString() {
        return "Particle[" + this.namespacedKey + ", extends:{" + this.getSuperParticle() + "}, particle: " + this.getParticle() + ", scripts:" + this.getScripts() + "]";
    }

    void prepare(String referencePath) {
        Context context = Context.enter();
        if (this.getScripts() != null) {
            for (String script : this.getScripts()) {
                if (script.startsWith("file=")) {
                    try {
                        FileInputStream inputStream = new FileInputStream(referencePath + File.separator + script.substring("file=".length()));
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                        context.evaluateReader(scope, bufferedReader, "<cmd>", 1, null);
                        Context.exit();
                    }
                    catch (IOException e) {
                        Main.getMainUtil().sendDebugMessage(e.getMessage());
                    }
                    continue;
                }
                context.evaluateString(scope, script, "<cmd>", 1, null);
                Context.exit();
            }
        }
    }

    public void spawnOnLocation(Location location, int tick) {
        Object function;
        Data particleData = new Data(this);
        if (this.getScripts() != null && !this.getScripts().isEmpty() && (function = scope.get("onLocation", scope)) instanceof Function) {
            Function f = (Function)function;
            f.call(Context.enter(), scope, scope, new Object[]{location, particleData, tick});
            Context.exit();
        }
        this.spawn(location, particleData);
    }

    public void spawnOnBlock(Block block, int tick) {
        Object function;
        Location location = block.getLocation();
        Data particleData = new Data(this);
        if (this.getScripts() != null && !this.getScripts().isEmpty() && (function = scope.get("onBlock", scope)) instanceof Function) {
            Function f = (Function)function;
            f.call(Context.enter(), scope, scope, new Object[]{block, location, particleData, tick});
            Context.exit();
        }
        this.spawn(location, particleData);
    }

    public void spawnOnPlayer(Player player, EquipmentSlot slot, int tick) {
        Object function;
        Location location = player.getLocation();
        Data particleData = new Data(this);
        if (this.getScripts() != null && !this.getScripts().isEmpty() && (function = scope.get("onPlayer", scope)) instanceof Function) {
            Function f = (Function)function;
            f.call(Context.enter(), scope, scope, new Object[]{player, slot, location, particleData, tick});
            Context.exit();
        }
        this.spawn(location, particleData);
    }

    private void spawn(Location location, Data particleData) {
        this.spawn(location, particleData.relativeX, particleData.relativeY, particleData.relativeZ, particleData.count, particleData.offsetX, particleData.offsetY, particleData.offsetZ, particleData.extra, particleData.data);
    }

    private void spawn(Location location, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, @Nullable Object data) {
        Bukkit.getScheduler().runTask((Plugin)Main.getInstance(), () -> {
            if (location.getWorld() != null) {
                if (data == null || this.getDataClass() == null || !this.getDataClass().isInstance(data)) {
                    location.getWorld().spawnParticle(this.getParticle(), location.add(x, y, z), count, offsetX, offsetY, offsetZ, extra);
                } else {
                    location.getWorld().spawnParticle(this.getParticle(), location.add(x, y, z), count, offsetX, offsetY, offsetZ, extra, data);
                }
            }
        });
    }

    static {
        Context.exit();
    }

    public static class Data {
        private Class<?> dataClass;
        private Object data;
        private double relativeX;
        private double relativeY;
        private double relativeZ;
        private double offsetX;
        private double offsetY;
        private double offsetZ;
        private int count;
        private double extra;

        public Data(Particle particle) {
            this.dataClass = particle.getDataClass();
            this.data = particle.getData();
            this.relativeX = particle.getRelativeX() == null ? 0.0 : particle.getRelativeX();
            this.relativeY = particle.getRelativeY() == null ? 0.0 : particle.getRelativeY();
            this.relativeZ = particle.getRelativeZ() == null ? 0.0 : particle.getRelativeZ();
            this.offsetX = particle.getOffsetX() == null ? 0.0 : particle.getOffsetX();
            this.offsetY = particle.getOffsetY() == null ? 0.0 : particle.getOffsetY();
            this.offsetZ = particle.getOffsetZ() == null ? 0.0 : particle.getOffsetZ();
            this.count = particle.getCount() == null ? 1 : particle.getCount();
            this.extra = particle.getExtra() == null ? 1.0 : particle.getExtra();
        }

        public Object getData() {
            return this.data;
        }

        public void setData(Object data) {
            if (this.dataClass.isInstance(data)) {
                this.data = data;
            }
        }

        public double getRelativeX() {
            return this.relativeX;
        }

        public void setRelativeX(double relativeX) {
            this.relativeX = relativeX;
        }

        public double getRelativeY() {
            return this.relativeY;
        }

        public void setRelativeY(double relativeY) {
            this.relativeY = relativeY;
        }

        public double getRelativeZ() {
            return this.relativeZ;
        }

        public void setRelativeZ(double relativeZ) {
            this.relativeZ = relativeZ;
        }

        public double getOffsetX() {
            return this.offsetX;
        }

        public void setOffsetX(double offsetX) {
            this.offsetX = offsetX;
        }

        public double getOffsetY() {
            return this.offsetY;
        }

        public void setOffsetY(double offsetY) {
            this.offsetY = offsetY;
        }

        public double getOffsetZ() {
            return this.offsetZ;
        }

        public void setOffsetZ(double offsetZ) {
            this.offsetZ = offsetZ;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public double getExtra() {
            return this.extra;
        }

        public void setExtra(double extra) {
            this.extra = extra;
        }
    }
}

