/*
 * Decompiled with CFR 0.152.
 */
package me.wolfyscript.utilities.api.custom_items;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import me.wolfyscript.utilities.api.custom_items.Meta;
import me.wolfyscript.utilities.api.custom_items.meta.AttributesModifiersMeta;
import me.wolfyscript.utilities.api.custom_items.meta.CustomDamageMeta;
import me.wolfyscript.utilities.api.custom_items.meta.CustomDurabilityMeta;
import me.wolfyscript.utilities.api.custom_items.meta.CustomItemTagMeta;
import me.wolfyscript.utilities.api.custom_items.meta.CustomModelDataMeta;
import me.wolfyscript.utilities.api.custom_items.meta.DamageMeta;
import me.wolfyscript.utilities.api.custom_items.meta.EnchantMeta;
import me.wolfyscript.utilities.api.custom_items.meta.FlagsMeta;
import me.wolfyscript.utilities.api.custom_items.meta.LoreMeta;
import me.wolfyscript.utilities.api.custom_items.meta.NameMeta;
import me.wolfyscript.utilities.api.custom_items.meta.PlayerHeadMeta;
import me.wolfyscript.utilities.api.custom_items.meta.PotionMeta;
import me.wolfyscript.utilities.api.custom_items.meta.RepairCostMeta;
import me.wolfyscript.utilities.api.custom_items.meta.UnbreakableMeta;
import me.wolfyscript.utilities.main.Main;
import org.bukkit.inventory.meta.ItemMeta;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class MetaSettings {
    private HashMap<String, Meta> metas = new HashMap();

    public MetaSettings() {
        this.addMeta(new AttributesModifiersMeta());
        this.addMeta(new CustomModelDataMeta());
        this.addMeta(new DamageMeta());
        this.addMeta(new EnchantMeta());
        this.addMeta(new FlagsMeta());
        this.addMeta(new LoreMeta());
        this.addMeta(new NameMeta());
        this.addMeta(new PlayerHeadMeta());
        this.addMeta(new PotionMeta());
        this.addMeta(new RepairCostMeta());
        this.addMeta(new UnbreakableMeta());
        this.addMeta(new CustomDamageMeta());
        this.addMeta(new CustomDurabilityMeta());
        this.addMeta(new CustomItemTagMeta());
    }

    public MetaSettings(String jsonString) {
        this();
        JSONParser parser = new JSONParser();
        JSONObject obj = null;
        if (!jsonString.isEmpty()) {
            try {
                obj = (JSONObject)parser.parse(jsonString);
            }
            catch (ParseException e) {
                Main.getMainUtil().sendConsoleWarning("Error getting JSONObject from String:");
                Main.getMainUtil().sendConsoleWarning("" + jsonString);
            }
        }
        if (obj != null) {
            Set keys = obj.keySet();
            for (String key : keys) {
                String value = (String)obj.get((Object)key);
                this.getMetaByID(key).parseFromJSON(value);
            }
        }
    }

    private void addMeta(Meta meta) {
        this.metas.put(meta.getId(), meta);
    }

    public Meta getMetaByID(String id) {
        return this.metas.get(id);
    }

    public List<String> getMetas() {
        return new ArrayList<String>(this.metas.keySet());
    }

    public boolean checkMeta(ItemMeta input, ItemMeta customItem) {
        for (Meta meta : this.metas.values()) {
            if (meta.check(input, customItem)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String id : this.metas.keySet()) {
            map.put(id, this.metas.get(id).toString());
        }
        JSONObject obj = new JSONObject(map);
        return obj.toString();
    }

    public static enum Option {
        EXACT,
        IGNORE,
        HIGHER,
        HIGHER_EXACT,
        LOWER,
        LOWER_EXACT,
        HIGHER_LOWER;

    }
}

