/*
 * Decompiled with CFR 0.152.
 */
package me.wolfyscript.utilities.api.inventory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.wolfyscript.utilities.api.WolfyUtilities;
import me.wolfyscript.utilities.api.inventory.ChatInputAction;
import me.wolfyscript.utilities.api.inventory.GuiClick;
import me.wolfyscript.utilities.api.inventory.GuiHandler;
import me.wolfyscript.utilities.api.inventory.GuiUpdateEvent;
import me.wolfyscript.utilities.api.inventory.InventoryAPI;
import me.wolfyscript.utilities.api.inventory.button.Button;
import me.wolfyscript.utilities.api.utils.chat.ClickData;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;

public class GuiWindow
implements Listener {
    private String clusterID;
    private String namespace;
    public String itemKey;
    private InventoryAPI inventoryAPI;
    private HashMap<GuiHandler, Inventory> cachedInventories;
    private HashMap<String, Button> buttons = new HashMap();
    private InventoryType inventoryType;
    private int size;

    public GuiWindow(String namespace, InventoryAPI inventoryAPI, int size) {
        this(namespace, namespace, inventoryAPI, null, size);
    }

    public GuiWindow(String namespace, InventoryAPI inventoryAPI, InventoryType inventoryType) {
        this(namespace, namespace, inventoryAPI, inventoryType, 0);
    }

    public GuiWindow(String namespace, String itemKey, InventoryAPI inventoryAPI, InventoryType inventoryType, int size) {
        this.namespace = namespace;
        this.inventoryAPI = inventoryAPI;
        this.itemKey = itemKey;
        this.cachedInventories = new HashMap();
        this.inventoryType = inventoryType;
        this.size = size;
        Bukkit.getPluginManager().registerEvents((Listener)this, inventoryAPI.getPlugin());
    }

    public InventoryType getInventoryType() {
        return this.inventoryType;
    }

    public WolfyUtilities getAPI() {
        return this.inventoryAPI.getWolfyUtilities();
    }

    public int getSize() {
        return this.size;
    }

    public void onInit() {
    }

    public boolean onClick(GuiClick guiClick) {
        return true;
    }

    public void update(GuiHandler guiHandler) {
        Bukkit.getScheduler().runTaskLater(this.inventoryAPI.getPlugin(), () -> {
            if (!guiHandler.isChatEventActive()) {
                GuiUpdateEvent event = new GuiUpdateEvent(guiHandler, this);
                Bukkit.getPluginManager().callEvent((Event)event);
            }
        }, 1L);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getItemKey() {
        return this.itemKey;
    }

    public void setItemKey(String newItemKey) {
        this.itemKey = newItemKey;
    }

    public void registerButton(Button button) {
        button.init(this);
        this.buttons.put(button.getId(), button);
    }

    public Button getButton(String id) {
        return this.buttons.get(id);
    }

    public boolean hasButton(String id) {
        return this.buttons.containsKey(id);
    }

    public void reloadInv(GuiHandler guiHandler) {
        guiHandler.reloadInv(guiHandler.getCurrentGuiCluster(), guiHandler.getCurrentInv().getNamespace());
    }

    public void openChat(GuiHandler guiHandler, String msg, ChatInputAction inputAction) {
        guiHandler.setChatInputAction(inputAction);
        guiHandler.close();
        guiHandler.getApi().sendPlayerMessage(guiHandler.getPlayer(), msg);
    }

    public void openChat(String guiCluster, String msgKey, GuiHandler guiHandler, ChatInputAction inputAction) {
        guiHandler.setChatInputAction(inputAction);
        guiHandler.close();
        guiHandler.getApi().sendPlayerMessage(guiHandler.getPlayer(), "$inventories." + guiCluster + ".global_messages." + msgKey + "$");
    }

    public void openChat(String msgKey, GuiHandler guiHandler, ChatInputAction inputAction) {
        guiHandler.setChatInputAction(inputAction);
        guiHandler.close();
        guiHandler.getApi().sendPlayerMessage(guiHandler.getPlayer(), "$inventories." + this.getClusterID() + "." + this.getNamespace() + ".messages." + msgKey + "$");
    }

    public void openActionChat(GuiHandler guiHandler, ClickData clickData, ChatInputAction inputAction) {
        guiHandler.setChatInputAction(inputAction);
        guiHandler.close();
        guiHandler.getApi().sendActionMessage(guiHandler.getPlayer(), clickData);
    }

    public void sendMessage(GuiHandler guiHandler, String msgKey) {
        guiHandler.getApi().sendPlayerMessage(guiHandler.getPlayer(), this.getClusterID(), this.getNamespace(), msgKey);
    }

    public void sendMessage(Player player, String msgKey) {
        this.inventoryAPI.getWolfyUtilities().sendPlayerMessage(player, this.getClusterID(), this.getNamespace(), msgKey);
    }

    public void sendMessage(GuiHandler guiHandler, String msgKey, String[] ... replacements) {
        guiHandler.getApi().sendPlayerMessage(guiHandler.getPlayer(), this.getClusterID(), this.getNamespace(), msgKey, replacements);
    }

    public void sendMessage(Player player, String msgKey, String[] ... replacements) {
        this.inventoryAPI.getWolfyUtilities().sendPlayerMessage(player, this.getClusterID(), this.getNamespace(), msgKey, replacements);
    }

    protected String getInventoryName() {
        return WolfyUtilities.translateColorCodes(this.inventoryAPI.getWolfyUtilities().getLanguageAPI().getActiveLanguage().replaceKeys("$inventories." + this.clusterID + "." + this.namespace + ".gui_name$"));
    }

    public void setClusterID(String clusterID) {
        this.clusterID = clusterID;
    }

    public Inventory getInventory(GuiHandler guiHandler) {
        return this.cachedInventories.get(guiHandler);
    }

    public boolean hasCachedInventory(GuiHandler guiHandler) {
        return this.cachedInventories.containsKey(guiHandler);
    }

    public void setCachedInventorie(GuiHandler guiHandler, Inventory inventory) {
        this.cachedInventories.put(guiHandler, inventory);
    }

    public String getClusterID() {
        return this.clusterID;
    }

    public String getID() {
        return this.clusterID + ":" + this.namespace;
    }

    public List<String> getHelpInformation() {
        ArrayList<String> values = new ArrayList<String>();
        for (String value : this.getAPI().getLanguageAPI().getActiveLanguage().replaceKey("$inventories." + this.clusterID + "." + this.namespace + ".gui_help$")) {
            values.add(WolfyUtilities.translateColorCodes(value));
        }
        return values;
    }
}

