/*
 * Decompiled with CFR 0.152.
 */
package me.wolfyscript.utilities.main.listeners;

import me.wolfyscript.utilities.api.custom_items.CustomItem;
import me.wolfyscript.utilities.api.custom_items.CustomItems;
import me.wolfyscript.utilities.api.custom_items.ParticleContent;
import me.wolfyscript.utilities.api.custom_items.equipment.ArmorEquipEvent;
import me.wolfyscript.utilities.api.custom_items.equipment.ArmorType;
import me.wolfyscript.utilities.api.utils.ItemUtils;
import me.wolfyscript.utilities.api.utils.NamespacedKey;
import me.wolfyscript.utilities.api.utils.particles.ParticleEffect;
import me.wolfyscript.utilities.api.utils.particles.ParticleEffects;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Dispenser;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class EquipListener
implements Listener {
    @EventHandler
    public void dispenseArmorEvent(BlockDispenseEvent event) {
        CustomItem customItem = CustomItem.getByItemStack(event.getItem());
        if (customItem != null && customItem.hasID() && customItem.hasEquipmentSlot()) {
            Location location = event.getBlock().getLocation();
            Dispenser dispenser = (Dispenser)event.getBlock().getState();
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onArmorEquip(ArmorEquipEvent event) {
        ArmorType type = event.getType();
        EquipmentSlot equipmentSlot = type.getEquipmentSlot();
        CustomItem newArmorPiece = event.getNewArmorPiece();
        if (!ItemUtils.isAirOrNull(newArmorPiece)) {
            if (ItemUtils.isEquipable(newArmorPiece.getType())) {
                if (newArmorPiece.getType().name().endsWith("_" + event.getType().name()) && newArmorPiece.isBlockVanillaEquip()) {
                    event.setCancelled(true);
                }
            } else {
                event.setCancelled(true);
            }
            if (newArmorPiece.hasID() && newArmorPiece.getEquipmentSlots().contains(equipmentSlot)) {
                NamespacedKey particleID;
                CustomItems.stopActiveParticleEffect(event.getPlayer(), equipmentSlot);
                ParticleContent particleContent = newArmorPiece.getParticleContent();
                if (particleContent != null && (particleID = particleContent.getParticleEffect(ParticleEffect.Action.valueOf(equipmentSlot.name()))) != null) {
                    CustomItems.setActiveParticleEffect(event.getPlayer(), equipmentSlot, ParticleEffects.spawnEffectOnPlayer(particleID, equipmentSlot, event.getPlayer()));
                }
                event.setCancelled(false);
            }
        } else {
            CustomItems.stopActiveParticleEffect(event.getPlayer(), equipmentSlot);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onClickInventory(InventoryClickEvent event) {
        boolean shift = event.isShiftClick();
        boolean numberkey = event.getClick().equals((Object)ClickType.NUMBER_KEY);
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (event.getClickedInventory() != null && !event.getClickedInventory().getType().equals((Object)InventoryType.PLAYER)) {
            return;
        }
        CustomItem item = CustomItem.getByItemStack(event.isShiftClick() ? event.getCurrentItem() : event.getCursor());
        if (item == null) {
            return;
        }
        ArmorType armorType = null;
        if (shift) {
            if (!event.getSlotType().equals((Object)InventoryType.SlotType.ARMOR)) {
                CustomItem newArmorPiece = CustomItem.getByItemStack(event.getCurrentItem());
                if (!ItemUtils.isAirOrNull(newArmorPiece) && newArmorPiece.hasEquipmentSlot()) {
                    int slot = -1;
                    for (int i = 39; i > 36; --i) {
                        if (!ItemUtils.isAirOrNull(event.getClickedInventory().getItem(i)) || !newArmorPiece.hasEquipmentSlot(ArmorType.getBySlot(i).getEquipmentSlot())) continue;
                        slot = i;
                    }
                    event.setCancelled(true);
                    if (slot == -1) {
                        return;
                    }
                    ArmorEquipEvent equipEvent = new ArmorEquipEvent(player, ArmorEquipEvent.EquipMethod.SHIFT_CLICK, ArmorType.getBySlot(slot), null, newArmorPiece);
                    Bukkit.getPluginManager().callEvent((Event)equipEvent);
                    if (equipEvent.isCancelled()) {
                        return;
                    }
                    newArmorPiece = equipEvent.getNewArmorPiece();
                    CustomItem oldArmorPiece = equipEvent.getOldArmorPiece();
                    event.getClickedInventory().setItem(slot, (ItemStack)(ItemUtils.isAirOrNull(newArmorPiece) ? null : newArmorPiece.getRealItem()));
                    event.getClickedInventory().setItem(event.getSlot(), (ItemStack)(ItemUtils.isAirOrNull(oldArmorPiece) ? null : oldArmorPiece.getRealItem()));
                }
            } else {
                CustomItem oldArmorPiece = CustomItem.getByItemStack(event.getCurrentItem());
                event.setCancelled(true);
                ArmorEquipEvent equipEvent = new ArmorEquipEvent(player, ArmorEquipEvent.EquipMethod.SHIFT_CLICK, ArmorType.getBySlot(event.getSlot()), oldArmorPiece, null);
                Bukkit.getPluginManager().callEvent((Event)equipEvent);
                if (equipEvent.isCancelled()) {
                    return;
                }
                CustomItem newArmorPiece = equipEvent.getNewArmorPiece();
                oldArmorPiece = equipEvent.getOldArmorPiece();
                if (!ItemUtils.isAirOrNull(oldArmorPiece)) {
                    event.getClickedInventory().addItem(new ItemStack[]{oldArmorPiece.getRealItem()});
                }
                event.getClickedInventory().setItem(event.getSlot(), (ItemStack)(ItemUtils.isAirOrNull(newArmorPiece) ? null : newArmorPiece.getRealItem()));
            }
        } else {
            CustomItem newArmorPiece = CustomItem.getByItemStack(event.getCursor());
            CustomItem oldArmorPiece = CustomItem.getByItemStack(event.getCurrentItem());
            if (numberkey) {
                if (event.getClickedInventory().getType().equals((Object)InventoryType.PLAYER)) {
                    CustomItem hotbarItem = CustomItem.getByItemStack(event.getClickedInventory().getItem(event.getHotbarButton()));
                    ArmorType type = ArmorType.getBySlot(event.getSlot());
                    if (type == null) {
                        return;
                    }
                    if (!ItemUtils.isAirOrNull(hotbarItem)) {
                        newArmorPiece = hotbarItem;
                        oldArmorPiece = CustomItem.getByItemStack(event.getClickedInventory().getItem(event.getSlot()));
                    }
                    ArmorEquipEvent equipEvent = new ArmorEquipEvent(player, ArmorEquipEvent.EquipMethod.HOTBAR_SWAP, ArmorType.getBySlot(event.getSlot()), oldArmorPiece, newArmorPiece);
                    Bukkit.getPluginManager().callEvent((Event)equipEvent);
                    if (equipEvent.isCancelled()) {
                        event.setCancelled(true);
                        return;
                    }
                    newArmorPiece = equipEvent.getNewArmorPiece();
                    oldArmorPiece = equipEvent.getOldArmorPiece();
                    if (ItemUtils.isEquipable(newArmorPiece.getType()) && newArmorPiece.getType().name().endsWith("_" + armorType.name())) {
                        return;
                    }
                    event.setCancelled(true);
                    event.getClickedInventory().setItem(event.getSlot(), (ItemStack)newArmorPiece.getRealItem());
                    event.getClickedInventory().setItem(event.getHotbarButton(), (ItemStack)(ItemUtils.isAirOrNull(oldArmorPiece) ? null : oldArmorPiece.getRealItem()));
                }
            } else if (event.getSlotType().equals((Object)InventoryType.SlotType.ARMOR)) {
                if (ItemUtils.isAirOrNull(newArmorPiece) && ItemUtils.isAirOrNull(oldArmorPiece)) {
                    return;
                }
                armorType = ArmorType.getBySlot(event.getSlot());
                if (!ItemUtils.isAirOrNull(newArmorPiece) && ItemUtils.isAirOrNull(oldArmorPiece)) {
                    armorType = ArmorType.getBySlot(event.getSlot());
                    if (!ItemUtils.isAirOrNull(oldArmorPiece) && event.isRightClick()) {
                        return;
                    }
                }
                ArmorEquipEvent equipEvent = new ArmorEquipEvent(player, ArmorEquipEvent.EquipMethod.PICK_DROP, ArmorType.getBySlot(event.getSlot()), oldArmorPiece, newArmorPiece);
                Bukkit.getPluginManager().callEvent((Event)equipEvent);
                if (equipEvent.isCancelled()) {
                    event.setCancelled(true);
                    return;
                }
                newArmorPiece = equipEvent.getNewArmorPiece();
                oldArmorPiece = equipEvent.getOldArmorPiece();
                if (ItemUtils.isEquipable(newArmorPiece.getType()) && newArmorPiece.getType().name().endsWith("_" + armorType.name())) {
                    return;
                }
                event.setCancelled(true);
                event.getClickedInventory().setItem(event.getSlot(), (ItemStack)newArmorPiece);
                event.getView().setCursor((ItemStack)oldArmorPiece);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void playerInteractEvent(PlayerInteractEvent e) {
        if (e.getAction() == Action.PHYSICAL) {
            return;
        }
        if (e.getAction() == Action.RIGHT_CLICK_AIR || e.getAction() == Action.RIGHT_CLICK_BLOCK) {
            Player player = e.getPlayer();
            if (e.getClickedBlock() != null && e.getAction() == Action.RIGHT_CLICK_BLOCK && !player.isSneaking() && e.getClickedBlock().getType().isInteractable()) {
                return;
            }
            CustomItem customItem = CustomItem.getByItemStack(e.getItem());
            if (customItem == null || !customItem.hasID() || customItem.hasEquipmentSlot()) {
                // empty if block
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void inventoryDrag(InventoryDragEvent event) {
    }
}

