/*
 * Decompiled with CFR 0.152.
 */
package me.wolfyscript.utilities.api.config.serialization;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import me.wolfyscript.utilities.main.Main;
import org.bukkit.Color;

public class ColorSerialization
implements JsonSerializer<Color>,
JsonDeserializer<Color> {
    public Color deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        if (jsonElement instanceof JsonObject) {
            byte red = ((JsonObject)jsonElement).get("red").getAsByte();
            byte green = ((JsonObject)jsonElement).get("green").getAsByte();
            byte blue = ((JsonObject)jsonElement).get("blue").getAsByte();
            return Color.fromBGR((int)red, (int)green, (int)blue);
        }
        Main.getMainUtil().sendConsoleWarning("Error Deserializing Color! Invalid Color object!");
        return null;
    }

    public JsonElement serialize(Color color, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject colorObj = new JsonObject();
        colorObj.addProperty("red", (Number)color.getRed());
        colorObj.addProperty("green", (Number)color.getGreen());
        colorObj.addProperty("blue", (Number)color.getBlue());
        return colorObj;
    }
}

