/*
 * Decompiled with CFR 0.152.
 */
package me.wolfyscript.utilities.api.utils.particles;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import me.wolfyscript.utilities.api.config.ConfigAPI;
import me.wolfyscript.utilities.api.config.JsonConfiguration;
import me.wolfyscript.utilities.api.utils.NamespacedKey;
import me.wolfyscript.utilities.api.utils.particles.Particle;

public class Particles
extends JsonConfiguration {
    private static LinkedHashMap<NamespacedKey, Particle> particles = new LinkedHashMap();
    private String namespace;

    public Particles(ConfigAPI configAPI) {
        this(configAPI, configAPI.getPlugin().getDataFolder().getPath(), "", "me/wolfyscript/utilities/api/utils/particles");
    }

    public Particles(ConfigAPI configAPI, String namespace) {
        this(configAPI, configAPI.getPlugin().getDataFolder().getPath(), namespace, "me/wolfyscript/utilities/api/utils/particles", false);
    }

    public Particles(ConfigAPI configAPI, String namespace, String defPath) {
        this(configAPI, configAPI.getPlugin().getDataFolder().getPath(), namespace, defPath, false);
    }

    public Particles(ConfigAPI configAPI, String path, String namespace, String defPath) {
        this(configAPI, path, namespace, defPath, false);
    }

    public Particles(ConfigAPI configAPI, String path, String namespace, String defPath, boolean override) {
        super(configAPI, path + File.separator + (namespace.isEmpty() ? "" : namespace + File.separator) + "particles", "particles", defPath, "particles", override);
        this.namespace = namespace.isEmpty() ? configAPI.getPlugin().getName().toLowerCase(Locale.ROOT).replace(" ", "_") : namespace;
    }

    public static LinkedHashMap<NamespacedKey, Particle> getParticles() {
        return new LinkedHashMap<NamespacedKey, Particle>(particles);
    }

    public static Particle getParticle(NamespacedKey namespacedKey) {
        return particles.get(namespacedKey);
    }

    public static void addOrReplaceParticle(NamespacedKey namespacedKey, Particle particle) {
        particles.put(namespacedKey, particle);
    }

    public static void addParticle(NamespacedKey namespacedKey, Particle particle) {
        if (!particles.containsKey(namespacedKey)) {
            particles.put(namespacedKey, particle);
        }
    }

    @Override
    public void reload() {
        super.reload(true);
    }

    @Override
    public void save() {
        super.save(true);
    }

    public void loadParticles() {
        for (String particleName : this.getKeys()) {
            Particle particle = this.get(Particle.class, particleName);
            if (particle == null) continue;
            NamespacedKey namespacedKey = new NamespacedKey(this.namespace, particleName);
            particle.setNamespacedKey(namespacedKey);
            particles.put(namespacedKey, particle);
        }
    }

    public void setParticles() {
        for (Map.Entry<NamespacedKey, Particle> particleEntry : particles.entrySet()) {
            if (!particleEntry.getKey().getNamespace().equalsIgnoreCase(this.namespace)) continue;
            this.set(particleEntry.getKey().getKey(), particleEntry.getValue());
        }
    }
}

