/*
 * Decompiled with CFR 0.152.
 */
package me.wolfyscript.utilities.api.inventory.button.buttons;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import me.wolfyscript.utilities.api.WolfyUtilities;
import me.wolfyscript.utilities.api.inventory.GuiHandler;
import me.wolfyscript.utilities.api.inventory.GuiWindow;
import me.wolfyscript.utilities.api.inventory.button.Button;
import me.wolfyscript.utilities.api.inventory.button.ButtonState;
import me.wolfyscript.utilities.api.inventory.button.ButtonType;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;

public class MultipleChoiceButton
extends Button {
    private List<ButtonState> states;
    private HashMap<GuiHandler, Integer> settings;

    public MultipleChoiceButton(String id, ButtonState ... states) {
        super(id, ButtonType.CHOICES);
        this.states = Arrays.asList(states);
        this.settings = new HashMap();
    }

    @Override
    public void init(GuiWindow guiWindow) {
        for (ButtonState btnState : this.states) {
            btnState.init(guiWindow);
        }
    }

    @Override
    public void init(String windowKey, WolfyUtilities api) {
        for (ButtonState btnState : this.states) {
            btnState.init(windowKey, api);
        }
    }

    @Override
    public boolean execute(GuiHandler guiHandler, Player player, Inventory inventory, int slot, InventoryClickEvent event) {
        int setting = this.settings.getOrDefault(guiHandler, 0);
        if (this.states != null && setting < this.states.size()) {
            ButtonState btnState = this.states.get(setting);
            if (++setting >= this.states.size()) {
                this.settings.put(guiHandler, 0);
            } else {
                this.settings.put(guiHandler, setting);
            }
            return btnState.getAction().run(guiHandler, player, inventory, slot, event);
        }
        return true;
    }

    @Override
    public void render(GuiHandler guiHandler, Player player, Inventory inventory, int slot, boolean help) {
        int setting = this.settings.getOrDefault(guiHandler, 0);
        if (this.states != null && this.states.size() > setting) {
            this.applyItem(guiHandler, player, inventory, this.states.get(setting), slot, help);
        }
    }

    public void setState(GuiHandler guiHandler, int state) {
        this.settings.put(guiHandler, state);
    }
}

