/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.feature.filter;

import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import net.engio.mbassy.listener.Filter;
import net.engio.mbassy.listener.IMessageFilter;
import net.engio.mbassy.subscription.SubscriptionContext;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.event.client.ClientReceiveCommandEvent;
import org.kitteh.irc.client.library.feature.filter.FilterProcessor;

@Filter(value=Processor.class)
@Repeatable(value=Commands.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
public @interface CommandFilter {
    public @NonNull String value();

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Commands {
        public @NonNull CommandFilter[] value();
    }

    public static class Processor
    implements FilterProcessor<ClientReceiveCommandEvent, CommandFilter>,
    IMessageFilter<ClientReceiveCommandEvent> {
        public boolean accepts(@NonNull ClientReceiveCommandEvent event, @NonNull CommandFilter[] commandFilters) {
            for (CommandFilter commandFilter : commandFilters) {
                if (!commandFilter.value().equalsIgnoreCase(event.getCommand())) continue;
                return true;
            }
            return false;
        }

        public boolean accepts(ClientReceiveCommandEvent event, SubscriptionContext context) {
            return this.accepts(event, (CommandFilter[])context.getHandler().getMethod().getAnnotationsByType(CommandFilter.class));
        }
    }
}

