/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.feature.auth;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.feature.auth.AbstractAccountSaslProtocol;
import org.kitteh.irc.client.library.util.Sanity;
import org.kitteh.irc.client.library.util.StringUtil;
import org.kitteh.irc.client.library.util.ToStringer;

public class SaslPlain
extends AbstractAccountSaslProtocol {
    private final String password;

    public SaslPlain(@NonNull Client client, @NonNull String accountName, @NonNull String password) {
        super(client, "PLAIN", accountName);
        this.password = Sanity.safeMessageCheck(password, "Password");
    }

    @Override
    protected @NonNull String getAuthLine() {
        return this.getAccountName() + '\u0000' + this.getAccountName() + '\u0000' + this.password;
    }

    @Override
    protected void toString(ToStringer stringer) {
        super.toString(stringer);
        stringer.add("password", StringUtil.filterPassword(this.password));
    }
}

