/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.event.user;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.element.ServerMessage;
import org.kitteh.irc.client.library.event.abstractbase.ServerMessageEventBase;
import org.kitteh.irc.client.library.util.Sanity;
import org.kitteh.irc.client.library.util.ToStringer;

public class MonitoredNickListFullEvent
extends ServerMessageEventBase {
    private final int limit;
    private final List<String> rejectedNicks;

    public MonitoredNickListFullEvent(@NonNull Client client, @NonNull ServerMessage sourceMessage, int limit, @NonNull List<String> rejectedNicks) {
        super(client, sourceMessage);
        this.limit = limit;
        this.rejectedNicks = Collections.unmodifiableList(new ArrayList(Sanity.nullCheck(rejectedNicks, "Rejected nicks")));
    }

    public int getLimit() {
        return this.limit;
    }

    public @NonNull List<String> getRejectedNicks() {
        return this.rejectedNicks;
    }

    @Override
    protected @NonNull ToStringer toStringer() {
        return super.toStringer().add("limit", this.limit).add("rejectedNicks", this.rejectedNicks);
    }
}

