/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.defaults.listener;

import net.engio.mbassy.listener.Handler;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.defaults.listener.AbstractDefaultListenerBase;
import org.kitteh.irc.client.library.element.Server;
import org.kitteh.irc.client.library.element.User;
import org.kitteh.irc.client.library.event.channel.ChannelNoticeEvent;
import org.kitteh.irc.client.library.event.channel.ChannelTargetedNoticeEvent;
import org.kitteh.irc.client.library.event.client.ClientReceiveCommandEvent;
import org.kitteh.irc.client.library.event.user.PrivateCtcpReplyEvent;
import org.kitteh.irc.client.library.event.user.PrivateNoticeEvent;
import org.kitteh.irc.client.library.event.user.ServerNoticeEvent;
import org.kitteh.irc.client.library.feature.filter.CommandFilter;
import org.kitteh.irc.client.library.util.CtcpUtil;

public class DefaultNoticeListener
extends AbstractDefaultListenerBase {
    public DefaultNoticeListener(@NonNull Client.WithManagement client) {
        super(client);
    }

    @CommandFilter(value="NOTICE")
    @Handler(priority=0x7FFFFFFE)
    public void notice(ClientReceiveCommandEvent event) {
        if (event.getParameters().size() < 2) {
            this.trackException(event, "NOTICE message too short");
            return;
        }
        String message = event.getParameters().get(1);
        if (!(event.getActor() instanceof User)) {
            if (event.getActor() instanceof Server) {
                if (CtcpUtil.isCtcp(message)) {
                    this.trackException(event, "Server sent a CTCP message and I panicked");
                    return;
                }
                this.fire(new ServerNoticeEvent((Client)this.getClient(), event.getSource(), (Server)event.getActor(), message));
            } else {
                this.trackException(event, "Message from neither server nor user");
            }
            return;
        }
        if (CtcpUtil.isCtcp(message)) {
            String ctcpMessage = CtcpUtil.fromCtcp(event.getParameters().get(1));
            AbstractDefaultListenerBase.MessageTargetInfo messageTargetInfo = this.getTypeByTarget(event.getParameters().get(0));
            User user = (User)event.getActor();
            if (messageTargetInfo instanceof AbstractDefaultListenerBase.MessageTargetInfo.Private) {
                this.fire(new PrivateCtcpReplyEvent((Client)this.getClient(), event.getSource(), user, event.getParameters().get(0), ctcpMessage));
            }
            return;
        }
        User user = (User)event.getActor();
        AbstractDefaultListenerBase.MessageTargetInfo messageTargetInfo = this.getTypeByTarget(event.getParameters().get(0));
        if (messageTargetInfo instanceof AbstractDefaultListenerBase.MessageTargetInfo.Private) {
            this.fire(new PrivateNoticeEvent((Client)this.getClient(), event.getSource(), user, event.getParameters().get(0), message));
        } else if (messageTargetInfo instanceof AbstractDefaultListenerBase.MessageTargetInfo.ChannelInfo) {
            AbstractDefaultListenerBase.MessageTargetInfo.ChannelInfo channelInfo = (AbstractDefaultListenerBase.MessageTargetInfo.ChannelInfo)messageTargetInfo;
            this.fire(new ChannelNoticeEvent((Client)this.getClient(), event.getSource(), user, channelInfo.getChannel(), message));
        } else if (messageTargetInfo instanceof AbstractDefaultListenerBase.MessageTargetInfo.TargetedChannel) {
            AbstractDefaultListenerBase.MessageTargetInfo.TargetedChannel channelInfo = (AbstractDefaultListenerBase.MessageTargetInfo.TargetedChannel)messageTargetInfo;
            this.fire(new ChannelTargetedNoticeEvent(this.getClient(), event.getSource(), user, channelInfo.getChannel(), channelInfo.getPrefix(), message));
        }
    }
}

