/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.defaults.listener;

import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.element.Channel;
import org.kitteh.irc.client.library.element.mode.ChannelUserMode;
import org.kitteh.irc.client.library.event.helper.ClientEvent;
import org.kitteh.irc.client.library.event.helper.ClientReceiveServerMessageEvent;
import org.kitteh.irc.client.library.exception.KittehServerMessageException;
import org.kitteh.irc.client.library.feature.ActorTracker;
import org.kitteh.irc.client.library.util.ToStringer;

public class AbstractDefaultListenerBase {
    private final Client.WithManagement client;

    public AbstractDefaultListenerBase(@NonNull Client.WithManagement client) {
        this.client = client;
    }

    public @NonNull String toString() {
        return new ToStringer(this).toString();
    }

    protected @NonNull Client.WithManagement getClient() {
        return this.client;
    }

    protected void fire(@NonNull ClientEvent event) {
        this.client.getEventManager().callEvent(event);
    }

    protected void trackException(@NonNull ClientReceiveServerMessageEvent event, @NonNull String reason) {
        this.client.getExceptionListener().queue(new KittehServerMessageException(event.getServerMessage(), reason));
    }

    protected @NonNull ActorTracker getTracker() {
        return this.client.getActorTracker();
    }

    protected @NonNull MessageTargetInfo getTypeByTarget(@NonNull String target) {
        Optional<Channel> channel = this.getTracker().getChannel(target);
        Optional<ChannelUserMode> prefix = this.getClient().getServerInfo().getTargetedChannelInfo(target);
        if (prefix.isPresent()) {
            return new MessageTargetInfo.TargetedChannel(this.getTracker().getChannel(target.substring(1)).get(), prefix.get());
        }
        if (channel.isPresent()) {
            return new MessageTargetInfo.ChannelInfo(channel.get());
        }
        return MessageTargetInfo.Private.INSTANCE;
    }

    protected static class MessageTargetInfo {
        protected MessageTargetInfo() {
        }

        public static class Private
        extends MessageTargetInfo {
            static final Private INSTANCE = new Private();

            private Private() {
            }

            public @NonNull String toString() {
                return new ToStringer(this).toString();
            }
        }

        public static class TargetedChannel
        extends MessageTargetInfo {
            private final Channel channel;
            private final ChannelUserMode prefix;

            private TargetedChannel(Channel channel, ChannelUserMode prefix) {
                this.channel = channel;
                this.prefix = prefix;
            }

            public @NonNull Channel getChannel() {
                return this.channel;
            }

            public @NonNull ChannelUserMode getPrefix() {
                return this.prefix;
            }

            public @NonNull String toString() {
                return new ToStringer(this).toString();
            }
        }

        public static class ChannelInfo
        extends MessageTargetInfo {
            private final Channel channel;

            private ChannelInfo(Channel channel) {
                this.channel = channel;
            }

            public @NonNull Channel getChannel() {
                return this.channel;
            }

            public @NonNull String toString() {
                return new ToStringer(this).toString();
            }
        }
    }
}

