/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.defaults.element.isupport;

import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.defaults.element.isupport.DefaultISupportParameterValueRequired;
import org.kitteh.irc.client.library.element.ISupportParameter;
import org.kitteh.irc.client.library.exception.KittehServerISupportException;
import org.kitteh.irc.client.library.feature.CaseMapping;

public class DefaultISupportCaseMapping
extends DefaultISupportParameterValueRequired
implements ISupportParameter.CaseMapping {
    private final CaseMapping caseMapping;

    public DefaultISupportCaseMapping(@NonNull Client client, @NonNull String name, @Nullable String value) {
        super(client, name, value);
        Optional<CaseMapping> caseMapping = CaseMapping.getByName(value);
        if (!caseMapping.isPresent()) {
            throw new KittehServerISupportException(name, "Undefined casemapping");
        }
        this.caseMapping = caseMapping.get();
    }

    @Override
    public @NonNull CaseMapping getCaseMapping() {
        return this.caseMapping;
    }
}

