/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.command;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.command.Command;
import org.kitteh.irc.client.library.util.Sanity;
import org.kitteh.irc.client.library.util.ToStringer;

public class SetNameCommand
extends Command<SetNameCommand> {
    private String newName;

    public SetNameCommand(@NonNull Client client) {
        super(client);
    }

    public @NonNull SetNameCommand newName(@Nullable String newName) {
        this.newName = newName == null ? null : Sanity.safeMessageCheck(newName);
        return this;
    }

    @Override
    public void execute() {
        if (this.newName == null) {
            throw new IllegalStateException("New name not specified");
        }
        if (!this.getClient().getCapabilityManager().getCapability("setname").isPresent()) {
            throw new IllegalStateException("Cannot send SETNAME when the capability is not negotiated");
        }
        this.sendCommandLine("SETNAME :" + this.newName);
    }

    @Override
    protected @NonNull ToStringer toStringer() {
        return super.toStringer().add("newName", this.newName);
    }
}

