/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.irc.client.library.command;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.kitteh.irc.client.library.Client;
import org.kitteh.irc.client.library.command.Command;
import org.kitteh.irc.client.library.util.Sanity;
import org.kitteh.irc.client.library.util.ToStringer;

public abstract class ChannelCommand<C extends ChannelCommand<C>>
extends Command<ChannelCommand<C>> {
    private final String channel;

    protected ChannelCommand(@NonNull Client client, @NonNull String channel) {
        super(client);
        Sanity.safeMessageCheck(channel, "Channel");
        Sanity.truthiness(client.getServerInfo().isValidChannel(channel), "Invalid channel name '" + channel + '\'');
        this.channel = channel;
    }

    public @NonNull String getChannel() {
        return this.channel;
    }

    @Override
    protected @NonNull ToStringer toStringer() {
        return super.toStringer().add("channel", this.getChannel());
    }
}

