/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.vanish.listeners;

import com.destroystokyo.paper.event.entity.PhantomPreSpawnEvent;
import com.destroystokyo.paper.event.entity.PlayerNaturallySpawnCreaturesEvent;
import com.destroystokyo.paper.event.player.PlayerAdvancementCriterionGrantEvent;
import com.destroystokyo.paper.event.player.PlayerPickupExperienceEvent;
import com.destroystokyo.paper.event.server.PaperServerListPingEvent;
import java.util.Iterator;
import java.util.Set;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.kitteh.vanish.VanishPerms;
import org.kitteh.vanish.VanishPlugin;

public class ListenPaperEvents
implements Listener {
    private final VanishPlugin plugin;

    public ListenPaperEvents(VanishPlugin instance) {
        this.plugin = instance;
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerAdvancementCriterionGrant(PlayerAdvancementCriterionGrantEvent event) {
        if (this.plugin.getManager().isVanished(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerPickupExperience(PlayerPickupExperienceEvent event) {
        if (this.plugin.getManager().isVanished(event.getPlayer()) && VanishPerms.canNotPickUp(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerNaturallySpawnCreatures(PlayerNaturallySpawnCreaturesEvent event) {
        if (this.plugin.getManager().isVanished(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPhantomPreSpawn(PhantomPreSpawnEvent event) {
        if (event.getSpawningEntity() instanceof Player && this.plugin.getManager().isVanished((Player)event.getSpawningEntity())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void ping(PaperServerListPingEvent event) {
        Set<String> invisibles = this.plugin.getManager().getVanishedPlayers();
        Iterator players = event.getListedPlayers().iterator();
        while (players.hasNext()) {
            PaperServerListPingEvent.ListedPlayerInfo player = (PaperServerListPingEvent.ListedPlayerInfo)players.next();
            if (!invisibles.contains(player.name())) continue;
            players.remove();
        }
    }
}

