/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc.statistics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.javalite.activejdbc.logging.LogFilter;
import org.javalite.activejdbc.logging.LogLevel;
import org.javalite.activejdbc.statistics.QueryExecutionEvent;
import org.javalite.activejdbc.statistics.QueryStats;
import org.javalite.activejdbc.statistics.SortBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsQueue {
    private final ExecutorService worker;
    private final ConcurrentMap<String, QueryStats> statsByQuery = new ConcurrentHashMap<String, QueryStats>();
    private volatile boolean paused;
    private static final Logger LOGGER = LoggerFactory.getLogger(StatisticsQueue.class);

    public StatisticsQueue(boolean paused) {
        this.paused = paused;
        this.worker = Executors.newFixedThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread res = new Thread(runnable);
                res.setDaemon(true);
                res.setName("Statistics queue thread");
                return res;
            }
        });
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void stop() {
        int notProcessed = this.worker.shutdownNow().size();
        if (notProcessed != 0) {
            LogFilter.log(LOGGER, LogLevel.INFO, "Worker exiting, {} execution events remaining, time: {}", (Object)notProcessed, (Object)System.currentTimeMillis());
        }
    }

    public void pause(boolean val) {
        this.paused = val;
    }

    public Future enqueue(final QueryExecutionEvent event) {
        if (!this.paused) {
            return this.worker.submit(new Runnable(){

                @Override
                public void run() {
                    QueryStats queryStats = (QueryStats)StatisticsQueue.this.statsByQuery.get(event.getQuery());
                    if (queryStats == null) {
                        queryStats = new QueryStats(event.getQuery());
                        StatisticsQueue.this.statsByQuery.put(event.getQuery(), queryStats);
                    }
                    queryStats.addQueryTime(event.getTime());
                }
            });
        }
        return null;
    }

    public void reset() {
        this.statsByQuery.clear();
    }

    public List<QueryStats> getReportSortedBy(String sortByVal) {
        SortBy sortBy;
        try {
            sortBy = SortBy.valueOf(sortByVal);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("allowed values are: " + Arrays.toString((Object[])SortBy.values()));
        }
        ArrayList<QueryStats> res = new ArrayList<QueryStats>(this.statsByQuery.values());
        Collections.sort(res, sortBy.getComparator());
        return res;
    }
}

