/*
 * Decompiled with CFR 0.152.
 */
package org.cyberiantiger.minecraft.nbt;

import org.cyberiantiger.minecraft.nbt.Tag;
import org.cyberiantiger.minecraft.nbt.TagType;

public final class FloatTag
extends Tag {
    private final float value;

    public FloatTag(float value) {
        this.value = value;
    }

    public Object getValue() {
        return Float.valueOf(this.getRawValue());
    }

    public float getRawValue() {
        return this.value;
    }

    @Override
    public TagType getType() {
        return TagType.FLOAT;
    }

    @Override
    public String toString() {
        return "" + this.getRawValue() + 'f';
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + Float.floatToIntBits(this.value);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FloatTag other = (FloatTag)obj;
        return Float.floatToIntBits(this.value) == Float.floatToIntBits(other.value);
    }
}

