/*
 * Decompiled with CFR 0.152.
 */
package org.cyberiantiger.minecraft.itemcontrol.libs.nmsutils.v1_20_R3;

import com.mojang.datafixers.DSL;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.SharedConstants;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import org.cyberiantiger.minecraft.itemcontrol.libs.nmsutils.NbtUtils;
import org.cyberiantiger.minecraft.itemcontrol.libs.nmsutils.nbt.CompoundTag;
import org.cyberiantiger.minecraft.itemcontrol.libs.nmsutils.v1_20_R3.CompoundTagImpl;
import org.cyberiantiger.minecraft.itemcontrol.libs.nmsutils.v1_20_R3.NMSUtilsImpl;

public class NbtUtilsImpl
implements NbtUtils {
    public NbtUtilsImpl(NMSUtilsImpl nmsUtils) {
    }

    @Override
    public CompoundTag parseBinary(byte[] in) {
        try {
            return new CompoundTagImpl(NBTCompressedStreamTools.a((DataInput)new DataInputStream(new ByteArrayInputStream(in))));
        }
        catch (IOException e) {
            throw new RuntimeException("invalid nbt");
        }
    }

    @Override
    public byte[] writeBinary(CompoundTag in) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            NBTCompressedStreamTools.a((NBTTagCompound)((CompoundTagImpl)in).handle, (DataOutput)new DataOutputStream(os));
        }
        catch (IOException e) {
            throw new RuntimeException("could not serialize nbt");
        }
        return os.toByteArray();
    }

    @Override
    public CompoundTag parseString(String in) {
        try {
            return new CompoundTagImpl(GameProfileSerializer.a((String)in));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not parse snbt string", e);
        }
    }

    @Override
    public String writeString(CompoundTag in) {
        return GameProfileSerializer.c((NBTTagCompound)((CompoundTagImpl)in).handle);
    }

    @Override
    public int getCurrentDataVersion() {
        return SharedConstants.b().d().c();
    }

    private CompoundTag updateNbt(DSL.TypeReference type, CompoundTag in, int oldVersion) {
        int currentVersion = this.getCurrentDataVersion();
        if (oldVersion >= currentVersion || in == null) {
            return in;
        }
        Dynamic dyn = new Dynamic((DynamicOps)DynamicOpsNBT.a, (Object)((CompoundTagImpl)in).handle);
        NBTBase out = (NBTBase)DataConverterRegistry.a().update(type, dyn, oldVersion, currentVersion).getValue();
        if (out instanceof NBTTagCompound) {
            NBTTagCompound compound = (NBTTagCompound)out;
            return new CompoundTagImpl(compound);
        }
        throw new RuntimeException("Expected CompoundTag as result of update, but got " + out.getClass().getName() + " !");
    }

    private String updateName(DSL.TypeReference type, String in, int oldVersion) {
        int currentVersion = this.getCurrentDataVersion();
        if (oldVersion >= currentVersion || in == null) {
            return in;
        }
        NBTBase out = (NBTBase)DataConverterRegistry.a().update(type, new Dynamic((DynamicOps)DynamicOpsNBT.a, (Object)NBTTagString.a((String)in)), oldVersion, currentVersion).getValue();
        if (out instanceof NBTTagString) {
            NBTTagString stringTag = (NBTTagString)out;
            return stringTag.t_();
        }
        throw new RuntimeException("Expected StringTag as result of update, but got " + out.getClass().getName() + " !");
    }

    @Override
    public CompoundTag updateEntity(CompoundTag in, int oldVersion) {
        return this.updateNbt(DataConverterTypes.x, in, oldVersion);
    }

    @Override
    public CompoundTag updateBlockState(CompoundTag in, int oldVersion) {
        return this.updateNbt(DataConverterTypes.s, in, oldVersion);
    }

    @Override
    public String updateItemTypeName(String in, int oldVersion) {
        return this.updateName(DataConverterTypes.z, in, oldVersion);
    }

    @Override
    public String updateBlockTypeName(String in, int oldVersion) {
        return this.updateName(DataConverterTypes.y, in, oldVersion);
    }
}

