/*
 * Decompiled with CFR 0.152.
 */
package org.cyberiantiger.minecraft.itemcontrol.items;

import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cyberiantiger.minecraft.nbt.CompoundTag;
import org.cyberiantiger.minecraft.nbt.ListTag;
import org.cyberiantiger.minecraft.nbt.MojangsonParser;
import org.cyberiantiger.minecraft.nbt.Tag;
import org.cyberiantiger.minecraft.nbt.TagTuple;
import org.cyberiantiger.minecraft.nbt.TagType;

public class ItemType {
    private static final Set<Short> DEFAULT_DAMAGE = Collections.singleton((short)0);
    private Set<Short> damage = DEFAULT_DAMAGE;
    private List<String> tags = Collections.emptyList();
    private transient Set<CompoundTag> parsedTags = null;

    public Set<Short> getDamage() {
        return this.damage;
    }

    public Set<CompoundTag> getParsedTags() {
        if (this.parsedTags == null) {
            if (this.tags.isEmpty()) {
                this.parsedTags = Collections.emptySet();
            } else {
                this.parsedTags = new HashSet<CompoundTag>(this.tags.size());
                for (String tag : this.tags) {
                    try {
                        CompoundTag ench;
                        ListTag enchList;
                        Tag[] enchArray;
                        MojangsonParser parser = new MojangsonParser(new StringReader(tag));
                        TagTuple result = parser.parse();
                        CompoundTag compoundTag = (CompoundTag)result.getValue();
                        this.parsedTags.add(compoundTag);
                        if (!compoundTag.containsKey("StoredEnchantments", TagType.LIST) || (enchArray = (enchList = compoundTag.getList("StoredEnchantments")).getValue()).length != 1 || !(enchArray[0] instanceof CompoundTag) || !(ench = (CompoundTag)enchArray[0]).containsKey("lvl", TagType.SHORT)) continue;
                        for (int level = ench.getShort("lvl") - 1; level >= 1; --level) {
                            parser = new MojangsonParser(new StringReader(tag));
                            result = parser.parse();
                            CompoundTag compoundTag2 = (CompoundTag)result.getValue();
                            ListTag enchList2 = compoundTag2.getList("StoredEnchantments");
                            Tag[] enchArray2 = enchList2.getValue();
                            CompoundTag ench2 = (CompoundTag)enchArray2[0];
                            ench2.setShort("lvl", (short)level);
                            this.parsedTags.add(compoundTag2);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return this.parsedTags;
    }
}

