/*
 * Decompiled with CFR 0.152.
 */
package org.cyberiantiger.minecraft.unsafe.v1_8_R3;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import net.minecraft.server.v1_8_R3.ChunkRegionLoader;
import net.minecraft.server.v1_8_R3.IChunkLoader;
import net.minecraft.server.v1_8_R3.NBTCompressedStreamTools;
import net.minecraft.server.v1_8_R3.NBTTagCompound;
import net.minecraft.server.v1_8_R3.ServerNBTManager;
import net.minecraft.server.v1_8_R3.WorldData;
import net.minecraft.server.v1_8_R3.WorldProvider;
import net.minecraft.server.v1_8_R3.WorldProviderHell;
import net.minecraft.server.v1_8_R3.WorldProviderTheEnd;
import org.bukkit.plugin.Plugin;
import org.cyberiantiger.minecraft.unsafe.v1_8_R3.InstanceChunkLoader;

class InstanceDataManager
extends ServerNBTManager {
    private static final String WORLD_DATA = "level.dat";
    private static final String WORLD_DATA_OLD = "level.dat_old";
    private final Plugin instances;
    private final File loadDataFolder;
    private final String world;

    public InstanceDataManager(Plugin instances, String instanceName, File loadDataFolder, File saveDataFolder) {
        super(saveDataFolder.getParentFile(), saveDataFolder.getName(), false);
        this.instances = instances;
        this.loadDataFolder = loadDataFolder;
        this.world = instanceName;
    }

    public WorldData getWorldData() {
        File levelData = new File(this.getDirectory(), WORLD_DATA);
        if (levelData.isFile()) {
            return super.getWorldData();
        }
        levelData = new File(this.getDirectory(), WORLD_DATA_OLD);
        if (levelData.isFile()) {
            return super.getWorldData();
        }
        File file1 = new File(this.loadDataFolder, WORLD_DATA);
        WorldData result = null;
        if (file1.exists()) {
            try {
                NBTTagCompound nbttagcompound = NBTCompressedStreamTools.a((InputStream)new FileInputStream(file1));
                NBTTagCompound nbttagcompound1 = nbttagcompound.getCompound("Data");
                result = new WorldData(nbttagcompound1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            file1 = new File(this.loadDataFolder, WORLD_DATA_OLD);
            if (file1.exists()) {
                try {
                    NBTTagCompound nbttagcompound = NBTCompressedStreamTools.a((InputStream)new FileInputStream(file1));
                    NBTTagCompound nbttagcompound1 = nbttagcompound.getCompound("Data");
                    result = new WorldData(nbttagcompound1);
                }
                catch (Exception exception1) {
                    exception1.printStackTrace();
                }
            }
        }
        if (result != null) {
            result.a(this.world);
        }
        return result;
    }

    public IChunkLoader createChunkLoader(WorldProvider wp) {
        File saveChunkDir;
        File loadChunkDir;
        if (wp instanceof WorldProviderHell) {
            loadChunkDir = new File(this.loadDataFolder, "DIM-1");
            saveChunkDir = new File(this.getDirectory(), "DIM-1");
        } else if (wp instanceof WorldProviderTheEnd) {
            loadChunkDir = new File(this.loadDataFolder, "DIM1");
            saveChunkDir = new File(this.getDirectory(), "DIM1");
        } else {
            loadChunkDir = this.loadDataFolder;
            saveChunkDir = this.getDirectory();
        }
        ChunkRegionLoader loadLoader = new ChunkRegionLoader(loadChunkDir);
        ChunkRegionLoader saveLoader = new ChunkRegionLoader(saveChunkDir);
        return new InstanceChunkLoader(loadLoader, saveLoader);
    }

    public File getDataFile(String string) {
        File result = new File(this.loadDataFolder, string + ".dat");
        if (result.isFile()) {
            return result;
        }
        File source = new File(this.getDirectory(), string + ".dat");
        if (!source.isFile()) {
            return result;
        }
        try {
            Files.copy((File)source, (File)result);
        }
        catch (IOException ex) {
            this.instances.getLogger().log(Level.SEVERE, "Error copying " + source.getPath() + " to " + result.getPath() + " for Instance world: " + this.world, ex);
        }
        return result;
    }
}

