/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.util;

import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathSearchFilter {
    private static final String COM_AVAJE_EBEANINTERNAL_SERVER_BEAN = "com.avaje.ebeaninternal.server.bean";
    private static final String COM_AVAJE_EBEAN_META = "com.avaje.ebean.meta";
    private boolean defaultPackageMatch = true;
    private boolean defaultJarMatch = false;
    private String ebeanJarPrefix = "ebean";
    private HashSet<String> includePackageSet = new HashSet();
    private HashSet<String> excludePackageSet = new HashSet();
    private HashSet<String> includeJarSet = new HashSet();
    private HashSet<String> excludeJarSet = new HashSet();

    public ClassPathSearchFilter() {
        this.addDefaultExcludePackages();
    }

    public void setEbeanJarPrefix(String ebeanJarPrefix) {
        this.ebeanJarPrefix = ebeanJarPrefix;
    }

    public Set<String> getIncludePackages() {
        return this.includePackageSet;
    }

    public void addDefaultExcludePackages() {
        this.excludePackage("sun");
        this.excludePackage("com.sun");
        this.excludePackage("java");
        this.excludePackage("javax");
        this.excludePackage("junit");
        this.excludePackage("org.w3c");
        this.excludePackage("org.xml");
        this.excludePackage("org.apache");
        this.excludePackage("com.mysql");
        this.excludePackage("oracle.jdbc");
        this.excludePackage("com.microsoft.sqlserver");
        this.excludePackage("com.avaje.ebean");
        this.excludePackage("com.avaje.lib");
    }

    public void clearExcludePackages() {
        this.excludePackageSet.clear();
    }

    public void setDefaultJarMatch(boolean defaultJarMatch) {
        this.defaultJarMatch = defaultJarMatch;
    }

    public void setDefaultPackageMatch(boolean defaultPackageMatch) {
        this.defaultPackageMatch = defaultPackageMatch;
    }

    public void includePackage(String pckgName) {
        this.includePackageSet.add(pckgName);
    }

    public void excludePackage(String pckgName) {
        this.excludePackageSet.add(pckgName);
    }

    public void excludeJar(String jarName) {
        this.includeJarSet.add(jarName);
    }

    public void includeJar(String jarName) {
        this.includeJarSet.add(jarName);
    }

    public boolean isSearchPackage(String packageName) {
        if (COM_AVAJE_EBEAN_META.equals(packageName)) {
            return true;
        }
        if (COM_AVAJE_EBEANINTERNAL_SERVER_BEAN.equals(packageName)) {
            return true;
        }
        if (this.includePackageSet != null && !this.includePackageSet.isEmpty()) {
            return this.containedIn(this.includePackageSet, packageName);
        }
        if (this.containedIn(this.excludePackageSet, packageName)) {
            return false;
        }
        return this.defaultPackageMatch;
    }

    public boolean isSearchJar(String jarName) {
        if (jarName.startsWith(this.ebeanJarPrefix)) {
            return true;
        }
        if (this.containedIn(this.includeJarSet, jarName)) {
            return true;
        }
        if (this.containedIn(this.excludeJarSet, jarName)) {
            return false;
        }
        return this.defaultJarMatch;
    }

    protected boolean containedIn(HashSet<String> set, String match) {
        if (set.contains(match)) {
            return true;
        }
        for (String val : set) {
            if (!match.startsWith(val)) continue;
            return true;
        }
        return false;
    }
}

