/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.specialsource;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import net.md_5.specialsource.AccessMap;
import net.md_5.specialsource.InheritanceMap;
import net.md_5.specialsource.Jar;
import net.md_5.specialsource.JarComparer;
import net.md_5.specialsource.JarMapping;
import net.md_5.specialsource.JarRemapper;
import net.md_5.specialsource.ProgressMeter;
import net.md_5.specialsource.RemapperProcessor;
import net.md_5.specialsource.provider.ClassLoaderProvider;
import net.md_5.specialsource.provider.JarProvider;
import net.md_5.specialsource.provider.JointProvider;
import net.md_5.specialsource.util.FileLocator;
import net.md_5.specialsource.util.Pair;
import org.objectweb.asm.ClassReader;

public class SpecialSource {
    private static OptionSet options;
    private static boolean verbose;
    public static boolean kill_source;
    public static boolean kill_lvt;
    public static boolean kill_generics;
    public static String identifier;
    public static boolean stable;

    public static void main(String[] args) throws Exception {
        JarMapping jarMapping;
        OptionParser parser = new OptionParser(){
            {
                this.acceptsAll(Arrays.asList("?", "help"), "Show the help");
                this.acceptsAll(Arrays.asList("a", "first-jar"), "First jar with original names, for generating mapping").withRequiredArg().ofType(String.class);
                this.acceptsAll(Arrays.asList("b", "second-jar"), "Second jar with renamed names, for generating mapping").withRequiredArg().ofType(String.class);
                this.acceptsAll(Arrays.asList("access-transformer"), "Access transformer file").withRequiredArg().ofType(File.class);
                this.acceptsAll(Arrays.asList("s", "srg-out"), "Mapping file output").withRequiredArg().ofType(File.class);
                this.acceptsAll(Arrays.asList("c", "compact"), "Output mapping file in compact format");
                this.acceptsAll(Arrays.asList("f", "generate-dupes"), "Include unrenamed symbols in mapping file output");
                this.acceptsAll(Arrays.asList("m", "srg-in"), "Mapping file input").withRequiredArg().ofType(String.class);
                this.acceptsAll(Arrays.asList("n", "numeric-srg"), "Use numeric .srg mappings with srg-in dir (num->mcp vs obf->mcp)");
                this.acceptsAll(Arrays.asList("R", "in-shade-relocation", "shade-relocation"), "Simulate maven-shade-plugin relocation patterns on srg-in input names").withRequiredArg();
                this.acceptsAll(Arrays.asList("out-shade-relocation"), "Simulate maven-shade-plugin relocation patterns on srg-in output names").withRequiredArg();
                this.acceptsAll(Arrays.asList("r", "reverse"), "Reverse input/output names on srg-in");
                this.acceptsAll(Arrays.asList("i", "in-jar"), "Input jar(s) to remap").withRequiredArg().ofType(String.class);
                this.acceptsAll(Arrays.asList("o", "out-jar"), "Output jar to write").withRequiredArg().ofType(File.class);
                this.acceptsAll(Arrays.asList("force-redownload"), "Force redownloading remote resources (invalid cache)");
                this.acceptsAll(Arrays.asList("l", "live"), "Enable runtime inheritance lookup");
                this.acceptsAll(Arrays.asList("L", "live-remapped"), "Enable runtime inheritance lookup through a mapping");
                this.acceptsAll(Arrays.asList("H", "write-inheritance"), "Write inheritance map to file").withRequiredArg().ofType(File.class);
                this.acceptsAll(Arrays.asList("h", "read-inheritance"), "Read inheritance map from file").withRequiredArg().ofType(String.class);
                this.acceptsAll(Arrays.asList("q", "quiet"), "Quiet mode");
                this.acceptsAll(Arrays.asList("progress-interval"), "% markers at which to print progress").withRequiredArg().ofType(Integer.class).defaultsTo(10, (Integer[])new Integer[0]);
                this.acceptsAll(Arrays.asList("stable"), "Attempts to make output stable for a given input");
                this.acceptsAll(Arrays.asList("v", "version"), "Displays version information");
                this.acceptsAll(Arrays.asList("kill-source"), "Removes the \"SourceFile\" attribute");
                this.acceptsAll(Arrays.asList("kill-lvt"), "Removes the \"LocalVariableTable\" attribute");
                this.acceptsAll(Arrays.asList("kill-generics"), "Removes the \"LocalVariableTypeTable\" and \"Signature\" attributes");
                this.acceptsAll(Arrays.asList("d", "identifier"), "Identifier to place on each class that is transformed, by default, none").withRequiredArg().ofType(String.class);
                this.acceptsAll(Arrays.asList("e", "excluded-packages"), "A comma seperated list of packages that should not be transformed, even if the srg specifies they should").withRequiredArg().ofType(String.class);
                this.acceptsAll(Arrays.asList("only"), "Process only the specified packages. Similar to --excluded-packages but applies at the processing rather than loading phase").withRequiredArg().ofType(String.class);
                this.acceptsAll(Arrays.asList("log"), "Output log to write").withRequiredArg().ofType(File.class);
            }
        };
        try {
            options = parser.parse(args);
        }
        catch (OptionException ex) {
            System.out.println(ex.getLocalizedMessage());
            System.exit(-1);
            return;
        }
        if (options == null || options.has("?")) {
            try {
                parser.printHelpOn(System.err);
            }
            catch (IOException ex) {
                System.out.println(ex.getLocalizedMessage());
            }
            System.exit(-1);
            return;
        }
        ProgressMeter.printInterval = ((Number)options.valueOf("progress-interval")).doubleValue();
        if (options.has("version")) {
            System.out.println("SpecialSource v{something}");
            return;
        }
        if (options.has("in-jar") && !options.has("out-jar")) {
            System.err.println("No output jar given, in-jar requires out-jar");
            parser.printHelpOn(System.err);
            System.exit(-1);
            return;
        }
        verbose = !options.has("quiet");
        kill_source = options.has("kill-source");
        kill_lvt = options.has("kill-lvt");
        kill_generics = options.has("kill-generics");
        if (options.has("identifier")) {
            identifier = (String)options.valueOf("identifier");
        }
        String[] excluded = new String[]{};
        if (options.has("excluded-packages")) {
            excluded = ((String)options.valueOf("excluded-packages")).split(",");
        }
        FileLocator.useCache = !options.has("force-redownload");
        stable = options.has("stable");
        Jar jar1 = null;
        Jar jar2 = null;
        Jar jar3 = null;
        if (options.has("first-jar") && options.has("second-jar")) {
            SpecialSource.log("Reading jars");
            jar1 = Jar.init(FileLocator.getFile((String)options.valueOf("first-jar")));
            jar2 = Jar.init(FileLocator.getFile((String)options.valueOf("second-jar")));
            if (jar1.getMain() == null || jar2.getMain() == null) {
                System.err.println("Jars for comparison must both define Main-Class manifest attribute");
                System.exit(-1);
                return;
            }
            SpecialSource.log("Creating jar compare");
            JarComparer visitor1 = new JarComparer(jar1);
            JarComparer visitor2 = new JarComparer(jar2);
            SpecialSource.visit(new Pair<Jar>(jar1, jar2), new Pair<JarComparer>(visitor1, visitor2), new Pair<String>(jar1.getMain(), jar2.getMain()));
            jarMapping = new JarMapping(visitor1, visitor2, (File)options.valueOf("srg-out"), options.has("compact"), options.has("generate-dupes"));
            for (String string : excluded) {
                jarMapping.addExcludedPackage(string);
            }
        } else if (options.has("srg-in")) {
            SpecialSource.log("Loading mappings");
            jarMapping = new JarMapping();
            for (String pkg : excluded) {
                jarMapping.addExcludedPackage(pkg);
            }
            boolean reverse = options.has("reverse");
            boolean numeric = options.has("numeric-srg");
            String inShadeRelocation = (String)options.valueOf("in-shade-relocation");
            String outShadeRelocation = (String)options.valueOf("out-shade-relocation");
            List<?> filenames = options.valuesOf("srg-in");
            for (String filename : filenames) {
                jarMapping.loadMappings(filename, reverse, numeric, inShadeRelocation, outShadeRelocation);
            }
        } else {
            System.err.println("No mappings given, first-jar/second-jar or srg-in required");
            parser.printHelpOn(System.err);
            System.exit(-1);
            return;
        }
        SpecialSource.log(jarMapping.packages.size() + " packages, " + jarMapping.classes.size() + " classes, " + jarMapping.fields.size() + " fields, " + jarMapping.methods.size() + " methods");
        JointProvider inheritanceProviders = new JointProvider();
        jarMapping.setFallbackInheritanceProvider(inheritanceProviders);
        if (options.has("live")) {
            inheritanceProviders.add(new ClassLoaderProvider(ClassLoader.getSystemClassLoader()));
        }
        if (options.has("read-inheritance")) {
            InheritanceMap inheritanceMap = new InheritanceMap();
            BiMap<String, String> inverseClassMap = HashBiMap.create(jarMapping.classes).inverse();
            File inheritanceFile = FileLocator.getFile((String)options.valueOf("read-inheritance"));
            Throwable throwable = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(inheritanceFile));){
                inheritanceMap.load(reader, inverseClassMap);
            }
            catch (Throwable filename) {
                Throwable throwable2 = filename;
                throw filename;
            }
            SpecialSource.log("Loaded inheritance map for " + inheritanceMap.size() + " classes");
            inheritanceProviders.add(inheritanceMap);
        }
        RemapperProcessor accessMapper = null;
        AccessMap access = null;
        if (options.has("access-transformer")) {
            access = new AccessMap();
            access.loadAccessTransformer((File)options.valueOf("access-transformer"));
            accessMapper = new RemapperProcessor(null, jarMapping, access);
        }
        if (options.has("in-jar") && options.has("out-jar")) {
            List<?> filenames = options.valuesOf("in-jar");
            ArrayList<File> files = new ArrayList<File>();
            for (String filename : filenames) {
                files.add(FileLocator.getFile(filename));
            }
            jar3 = Jar.init(files);
            inheritanceProviders.add(new JarProvider(jar3));
            SpecialSource.log("Remapping final jar");
            JarRemapper jarRemapper = new JarRemapper(null, jarMapping, accessMapper);
            if (options.has("log")) {
                File logOutput = (File)options.valueOf("log");
                jarRemapper.setLogFile(logOutput);
            }
            jarRemapper.remapJar(jar3, (File)options.valueOf("out-jar"), new HashSet<String>(options.valuesOf("only")));
        }
        if (options.has("write-inheritance")) {
            InheritanceMap inheritanceMap = new InheritanceMap();
            inheritanceMap.generate(inheritanceProviders, jarMapping.classes.values());
            Throwable throwable = null;
            try (PrintWriter printWriter = new PrintWriter((File)options.valueOf("write-inheritance"));){
                inheritanceMap.save(printWriter);
            }
            catch (Throwable throwable3) {
                Throwable throwable4 = throwable3;
                throw throwable3;
            }
        }
        if (access != null) {
            for (String entry : access.getMap().keySet()) {
                if (access.getAppliedMaps().contains(entry)) continue;
                System.out.println("[WARN] Access map not applied: " + entry);
            }
        }
        if (jar1 != null) {
            jar1.close();
        }
        if (jar2 != null) {
            jar2.close();
        }
        if (jar3 != null) {
            jar3.close();
        }
    }

    public static void log(String message) {
        if (options != null && !options.has("quiet")) {
            System.out.println(message);
        }
    }

    private static void visit(Pair<Jar> jars, Pair<JarComparer> visitors, Pair<String> classes) throws IOException {
        ClassReader clazz2;
        ClassReader clazz1;
        JarComparer visitor1 = (JarComparer)visitors.first;
        JarComparer visitor2 = (JarComparer)visitors.second;
        try (InputStream first = ((Jar)jars.first).getClass((String)classes.first);
             InputStream second = ((Jar)jars.second).getClass((String)classes.second);){
            clazz1 = new ClassReader(first);
            clazz2 = new ClassReader(second);
        }
        clazz1.accept(visitor1, 0);
        clazz2.accept(visitor2, 0);
        SpecialSource.validate(visitor1, visitor2);
        while (visitor1.iterDepth < visitor1.classes.size()) {
            String className1 = visitor1.classes.get(visitor1.iterDepth);
            String className2 = visitor2.classes.get(visitor1.iterDepth);
            Pair<String> pair = new Pair<String>(className1, className2);
            ++visitor1.iterDepth;
            SpecialSource.visit(jars, visitors, pair);
        }
    }

    public static void validate(JarComparer visitor1, JarComparer visitor2) {
        if (visitor1.classes.size() != visitor2.classes.size()) {
            throw new IllegalStateException("classes " + visitor1.classes.size() + " != " + visitor2.classes.size());
        }
        if (visitor1.fields.size() != visitor2.fields.size()) {
            throw new IllegalStateException("fields " + visitor1.fields.size() + " != " + visitor2.fields.size());
        }
        if (visitor1.methods.size() != visitor2.methods.size()) {
            throw new IllegalStateException("methods " + visitor1.methods.size() + " != " + visitor2.methods.size());
        }
    }

    public static boolean verbose() {
        return verbose;
    }

    static {
        kill_source = false;
        kill_lvt = false;
        kill_generics = false;
        identifier = null;
        stable = false;
    }
}

