/*
 * Decompiled with CFR 0.152.
 */
package net.luckperms.api.cacheddata;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.function.Function;
import net.luckperms.api.cacheddata.CachedData;
import net.luckperms.api.cacheddata.Result;
import net.luckperms.api.metastacking.MetaStackDefinition;
import net.luckperms.api.node.types.MetaNode;
import net.luckperms.api.node.types.PrefixNode;
import net.luckperms.api.node.types.SuffixNode;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public interface CachedMetaData
extends CachedData {
    public @NonNull Result<String, MetaNode> queryMetaValue(@NonNull String var1);

    default public @Nullable String getMetaValue(@NonNull String key) {
        return this.queryMetaValue(key).result();
    }

    default public <T> @NonNull Optional<T> getMetaValue(@NonNull String key, @NonNull Function<String, ? extends T> valueTransformer) {
        return Optional.ofNullable(this.getMetaValue(key)).map(value -> {
            try {
                return valueTransformer.apply((String)value);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        });
    }

    public @NonNull Result<String, PrefixNode> queryPrefix();

    default public @Nullable String getPrefix() {
        return this.queryPrefix().result();
    }

    public @NonNull Result<String, SuffixNode> querySuffix();

    default public @Nullable String getSuffix() {
        return this.querySuffix().result();
    }

    public @NonNull @Unmodifiable Map<String, List<String>> getMeta();

    public @NonNull @Unmodifiable SortedMap<Integer, String> getPrefixes();

    public @NonNull @Unmodifiable SortedMap<Integer, String> getSuffixes();

    public @Nullable String getPrimaryGroup();

    public @NonNull MetaStackDefinition getPrefixStackDefinition();

    public @NonNull MetaStackDefinition getSuffixStackDefinition();
}

