/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.text.serializer.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.text.BlockNbtComponent;

public class BlockNbtComponentPosSerializer
implements JsonDeserializer<BlockNbtComponent.Pos>,
JsonSerializer<BlockNbtComponent.Pos> {
    public static final BlockNbtComponentPosSerializer INSTANCE = new BlockNbtComponentPosSerializer();
    private static final Pattern LOCAL_PATTERN = Pattern.compile("^\\^(\\d+(\\.\\d+)?) \\^(\\d+(\\.\\d+)?) \\^(\\d+(\\.\\d+)?)$");
    private static final Pattern WORLD_PATTERN = Pattern.compile("^(~?)(\\d+) (~?)(\\d+) (~?)(\\d+)$");

    public BlockNbtComponent.Pos deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String string = json.getAsString();
        Matcher localMatch = LOCAL_PATTERN.matcher(string);
        if (localMatch.matches()) {
            return BlockNbtComponent.LocalPos.of((double)Double.parseDouble(localMatch.group(1)), (double)Double.parseDouble(localMatch.group(3)), (double)Double.parseDouble(localMatch.group(5)));
        }
        Matcher worldMatch = WORLD_PATTERN.matcher(string);
        if (worldMatch.matches()) {
            return BlockNbtComponent.WorldPos.of((BlockNbtComponent.WorldPos.Coordinate)BlockNbtComponentPosSerializer.deserializeCoordinate(worldMatch.group(1), worldMatch.group(2)), (BlockNbtComponent.WorldPos.Coordinate)BlockNbtComponentPosSerializer.deserializeCoordinate(worldMatch.group(3), worldMatch.group(4)), (BlockNbtComponent.WorldPos.Coordinate)BlockNbtComponentPosSerializer.deserializeCoordinate(worldMatch.group(5), worldMatch.group(6)));
        }
        throw new JsonParseException("Don't know how to turn " + string + " into a Position");
    }

    public JsonElement serialize(BlockNbtComponent.Pos src, Type typeOfSrc, JsonSerializationContext context) {
        if (src instanceof BlockNbtComponent.LocalPos) {
            BlockNbtComponent.LocalPos local = (BlockNbtComponent.LocalPos)src;
            return new JsonPrimitive("^" + local.left() + ' ' + '^' + local.up() + ' ' + '^' + local.forwards());
        }
        if (src instanceof BlockNbtComponent.WorldPos) {
            BlockNbtComponent.WorldPos world = (BlockNbtComponent.WorldPos)src;
            return new JsonPrimitive(BlockNbtComponentPosSerializer.serializeCoordinate(world.x()) + ' ' + BlockNbtComponentPosSerializer.serializeCoordinate(world.y()) + ' ' + BlockNbtComponentPosSerializer.serializeCoordinate(world.z()));
        }
        throw new IllegalArgumentException("Don't know how to serialize " + src + " as a Position");
    }

    private static BlockNbtComponent.WorldPos.Coordinate deserializeCoordinate(String prefix, String value) {
        int i = Integer.parseInt(value);
        if (prefix.isEmpty()) {
            return BlockNbtComponent.WorldPos.Coordinate.absolute((int)i);
        }
        if (prefix.equals("~")) {
            return BlockNbtComponent.WorldPos.Coordinate.relative((int)i);
        }
        throw new AssertionError();
    }

    private static String serializeCoordinate(BlockNbtComponent.WorldPos.Coordinate coordinate) {
        return (coordinate.type() == BlockNbtComponent.WorldPos.Coordinate.Type.RELATIVE ? "~" : "") + coordinate.value();
    }
}

