/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.serializer.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.text.event.HoverEvent;

final class ShowItemSerializer
implements JsonDeserializer<HoverEvent.ShowItem>,
JsonSerializer<HoverEvent.ShowItem> {
    static final String ID = "id";
    static final String COUNT = "count";
    static final String TAG = "tag";

    ShowItemSerializer() {
    }

    public HoverEvent.ShowItem deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = json.getAsJsonObject();
        if (!object.has(ID)) {
            throw new JsonParseException("Not sure how to deserialize show_item hover event");
        }
        Key id = (Key)context.deserialize((JsonElement)object.getAsJsonPrimitive(ID), Key.class);
        int count = 1;
        if (object.has(COUNT)) {
            count = object.get(COUNT).getAsInt();
        }
        BinaryTagHolder nbt = null;
        if (object.has(TAG)) {
            JsonElement tag = object.get(TAG);
            if (tag.isJsonPrimitive()) {
                nbt = BinaryTagHolder.of((String)tag.getAsString());
            } else if (!tag.isJsonNull()) {
                throw new JsonParseException("Expected tag to be a string");
            }
        }
        return HoverEvent.ShowItem.of((Key)id, (int)count, nbt);
    }

    public JsonElement serialize(HoverEvent.ShowItem src, Type typeOfSrc, JsonSerializationContext context) {
        BinaryTagHolder nbt;
        JsonObject json = new JsonObject();
        json.add(ID, context.serialize((Object)src.item()));
        int count = src.count();
        if (count != 1) {
            json.addProperty(COUNT, (Number)count);
        }
        if ((nbt = src.nbt()) != null) {
            json.addProperty(TAG, nbt.string());
        }
        return json;
    }
}

