/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers.codecs;

import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.AbstractWrapper;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Function;

public class WrappedDataResult
extends AbstractWrapper {
    private static final Class<?> HANDLE_TYPE = MinecraftReflection.getLibraryClass("com.mojang.serialization.DataResult");
    private static final Optional<Class<?>> PARTIAL_DATA_RESULT_CLASS = MinecraftReflection.getOptionalLibraryClass("com.mojang.serialization.DataResult$PartialResult");
    private static final MethodAccessor ERROR_ACCESSOR = Accessors.getMethodAccessor(HANDLE_TYPE, "error", new Class[0]);
    private static final MethodAccessor RESULT_ACCESSOR = Accessors.getMethodAccessor(HANDLE_TYPE, "result", new Class[0]);
    private static MethodAccessor PARTIAL_RESULT_MESSAGE_ACCESSOR;

    public WrappedDataResult(Object handle) {
        super(HANDLE_TYPE);
        this.setHandle(handle);
    }

    public static WrappedDataResult fromHandle(Object handle) {
        return new WrappedDataResult(handle);
    }

    public Optional<Object> getResult() {
        return (Optional)RESULT_ACCESSOR.invoke(this.handle, new Object[0]);
    }

    public Optional<String> getErrorMessage() {
        return (Optional)ERROR_ACCESSOR.invoke(this.handle, new Object[0]);
    }

    public Object getOrThrow(Function<String, Throwable> errorHandler) {
        Optional<String> err = this.getErrorMessage();
        if (err.isPresent()) {
            return errorHandler.apply((String)PARTIAL_RESULT_MESSAGE_ACCESSOR.invoke(err.get(), new Object[0]));
        }
        Optional<Object> result = this.getResult();
        if (result.isPresent()) {
            return result.get();
        }
        throw new NoSuchElementException();
    }

    static {
        if (PARTIAL_DATA_RESULT_CLASS.isPresent()) {
            PARTIAL_RESULT_MESSAGE_ACCESSOR = Accessors.getMethodAccessor(PARTIAL_DATA_RESULT_CLASS.get(), "message", new Class[0]);
        }
    }
}

