/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.injector.BukkitUnwrapper;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.FieldAccessor;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.comphenix.protocol.wrappers.ClonableWrapper;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.ping.LegacyServerPing;
import com.comphenix.protocol.wrappers.ping.ServerPingImpl;
import com.comphenix.protocol.wrappers.ping.ServerPingRecord;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import org.bukkit.entity.Player;

public class WrappedServerPing
implements ClonableWrapper {
    private static final Class<?> GAME_PROFILE = MinecraftReflection.getGameProfileClass();
    private static final FieldAccessor ENTITY_HUMAN_PROFILE = Accessors.getFieldAccessor(MinecraftReflection.getEntityPlayerClass().getSuperclass(), GAME_PROFILE, true);
    private final ServerPingImpl impl;

    public WrappedServerPing() {
        this.impl = WrappedServerPing.newImpl();
    }

    private WrappedServerPing(Object handle) {
        this.impl = WrappedServerPing.newImpl(handle);
    }

    private static ServerPingImpl newImpl() {
        if (MinecraftVersion.FEATURE_PREVIEW_2.atOrAbove()) {
            return new ServerPingRecord();
        }
        return new LegacyServerPing();
    }

    private static ServerPingImpl newImpl(Object handle) {
        if (MinecraftVersion.FEATURE_PREVIEW_2.atOrAbove()) {
            return new ServerPingRecord(handle);
        }
        return new LegacyServerPing(handle);
    }

    private void resetPlayers() {
        this.impl.resetPlayers();
    }

    private void resetVersion() {
        this.impl.resetVersion();
    }

    public static WrappedServerPing fromHandle(Object handle) {
        return new WrappedServerPing(handle);
    }

    public static WrappedServerPing fromJson(String json) {
        if (MinecraftVersion.FEATURE_PREVIEW_2.atOrAbove()) {
            return new WrappedServerPing(ServerPingRecord.fromJson(json).getHandle());
        }
        return new WrappedServerPing(LegacyServerPing.fromJson(json));
    }

    public WrappedChatComponent getMotD() {
        return this.impl.getMotD();
    }

    public void setMotD(WrappedChatComponent description) {
        this.impl.setMotD(description);
    }

    public void setMotD(String message) {
        this.setMotD(WrappedChatComponent.fromLegacyText(message));
    }

    public CompressedImage getFavicon() {
        return this.impl.getFavicon();
    }

    public void setFavicon(CompressedImage image) {
        this.impl.setFavicon(image);
    }

    @Deprecated
    public boolean isChatPreviewEnabled() {
        return this.impl.isChatPreviewEnabled();
    }

    @Deprecated
    public void setChatPreviewEnabled(boolean chatPreviewEnabled) {
        this.impl.setChatPreviewEnabled(chatPreviewEnabled);
    }

    public boolean isEnforceSecureChat() {
        return this.impl.isEnforceSecureChat();
    }

    public void setEnforceSecureChat(boolean enforceSecureChat) {
        this.impl.setEnforceSecureChat(enforceSecureChat);
    }

    public int getPlayersOnline() {
        return this.impl.getPlayersOnline();
    }

    public void setPlayersOnline(int online) {
        this.impl.setPlayersOnline(online);
    }

    public int getPlayersMaximum() {
        return this.impl.getPlayersMaximum();
    }

    public void setPlayersMaximum(int maximum) {
        this.impl.setPlayersMaximum(maximum);
    }

    public void setPlayersVisible(boolean visible) {
        if (this.isPlayersVisible() != visible) {
            this.impl.setPlayersVisible(visible);
        }
    }

    public boolean isPlayersVisible() {
        return this.impl.arePlayersVisible();
    }

    public ImmutableList<WrappedGameProfile> getPlayers() {
        return this.impl.getPlayers();
    }

    public void setPlayers(Iterable<? extends WrappedGameProfile> profile) {
        if (!this.isPlayersVisible()) {
            this.resetPlayers();
        }
        this.impl.setPlayers(profile);
    }

    public void setBukkitPlayers(Iterable<? extends Player> players) {
        ArrayList<WrappedGameProfile> profiles = new ArrayList<WrappedGameProfile>();
        for (Player player : players) {
            Object profile = ENTITY_HUMAN_PROFILE.get(BukkitUnwrapper.getInstance().unwrapItem(player));
            profiles.add(WrappedGameProfile.fromHandle(profile));
        }
        this.setPlayers(profiles);
    }

    public String getVersionName() {
        return this.impl.getVersionName();
    }

    public void setVersionName(String name) {
        this.impl.setVersionName(name);
    }

    public int getVersionProtocol() {
        return this.impl.getVersionProtocol();
    }

    public void setVersionProtocol(int protocol) {
        this.impl.setVersionProtocol(protocol);
    }

    @Override
    public Object getHandle() {
        return this.impl.getHandle();
    }

    @Override
    public WrappedServerPing deepClone() {
        WrappedServerPing copy = new WrappedServerPing();
        WrappedChatComponent motd = this.getMotD();
        copy.setPlayers((Iterable<? extends WrappedGameProfile>)this.getPlayers());
        copy.setFavicon(this.getFavicon());
        copy.setMotD(motd != null ? motd.deepClone() : null);
        copy.setVersionName(this.getVersionName());
        copy.setVersionProtocol(this.getVersionProtocol());
        if (this.isPlayersVisible()) {
            copy.setPlayersMaximum(this.getPlayersMaximum());
            copy.setPlayersOnline(this.getPlayersOnline());
        } else {
            copy.setPlayersVisible(false);
        }
        return copy;
    }

    public String toJson() {
        return this.impl.getJson();
    }

    public String toString() {
        return "WrappedServerPing< " + this.toJson() + ">";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WrappedServerPing)) {
            return false;
        }
        return this.getHandle().equals(((WrappedServerPing)obj).getHandle());
    }

    public int hashCode() {
        return this.getHandle().hashCode();
    }

    public static class CompressedImage {
        protected volatile String mime;
        protected volatile byte[] data;
        protected volatile String encoded;

        protected CompressedImage() {
        }

        public CompressedImage(String mime, byte[] data) {
            this.mime = (String)Preconditions.checkNotNull((Object)mime, (Object)"mime cannot be NULL");
            this.data = (byte[])Preconditions.checkNotNull((Object)data, (Object)"data cannot be NULL");
        }

        public static CompressedImage fromPng(InputStream input) throws IOException {
            return new CompressedImage("image/png", ByteStreams.toByteArray((InputStream)input));
        }

        public static CompressedImage fromPng(byte[] data) {
            return new CompressedImage("image/png", data);
        }

        public static CompressedImage fromBase64Png(String base64) {
            try {
                return new EncodedCompressedImage("data:image/png;base64," + base64);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Must be a pure base64 encoded string. Cannot be an encoded text.", e);
            }
        }

        public static CompressedImage fromPng(RenderedImage image) throws IOException {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            ImageIO.write(image, "png", output);
            return new CompressedImage("image/png", output.toByteArray());
        }

        public static CompressedImage fromEncodedText(String text) {
            return new EncodedCompressedImage(text);
        }

        public String getMime() {
            return this.mime;
        }

        public byte[] getDataCopy() {
            return (byte[])this.getData().clone();
        }

        protected byte[] getData() {
            return this.data;
        }

        public BufferedImage getImage() throws IOException {
            return ImageIO.read(new ByteArrayInputStream(this.getData()));
        }

        public String toEncodedText() {
            if (this.encoded == null) {
                ByteBuf buffer = Unpooled.wrappedBuffer((byte[])this.getDataCopy());
                this.encoded = "data:" + this.getMime() + ";base64," + Base64.encode((ByteBuf)buffer).toString(StandardCharsets.UTF_8);
            }
            return this.encoded;
        }
    }

    private static class EncodedCompressedImage
    extends CompressedImage {
        public EncodedCompressedImage(String encoded) {
            this.encoded = (String)Preconditions.checkNotNull((Object)encoded, (Object)"encoded favicon cannot be NULL");
        }

        protected void initialize() {
            if (this.mime == null || this.data == null) {
                this.decode();
            }
        }

        protected void decode() {
            for (String segment : Splitter.on((String)";").split((CharSequence)this.encoded)) {
                if (segment.startsWith("data:")) {
                    this.mime = segment.substring(5);
                    continue;
                }
                if (!segment.startsWith("base64,")) continue;
                byte[] encoded = segment.substring(7).getBytes(StandardCharsets.UTF_8);
                ByteBuf decoded = Base64.decode((ByteBuf)Unpooled.wrappedBuffer((byte[])encoded));
                byte[] data = new byte[decoded.readableBytes()];
                decoded.readBytes(data);
                this.data = data;
            }
        }

        @Override
        protected byte[] getData() {
            this.initialize();
            return super.getData();
        }

        @Override
        public String getMime() {
            this.initialize();
            return super.getMime();
        }

        @Override
        public String toEncodedText() {
            return this.encoded;
        }
    }
}

