/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.injector.BukkitUnwrapper;
import com.comphenix.protocol.reflect.FieldAccessException;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.ConstructorAccessor;
import com.comphenix.protocol.reflect.accessors.FieldAccessor;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.reflect.fuzzy.FuzzyFieldContract;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.AbstractWrapper;
import com.comphenix.protocol.wrappers.IDataWatcher;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import com.comphenix.protocol.wrappers.collection.ConvertedMap;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;

public class LegacyDataWatcher
extends AbstractWrapper
implements IDataWatcher {
    private static final Class<?> HANDLE_TYPE = MinecraftReflection.getDataWatcherClass();
    private static MethodAccessor GETTER = null;
    private static MethodAccessor SETTER = null;
    private static MethodAccessor REGISTER = null;
    private static FieldAccessor ENTITY_DATA_FIELD = null;
    private static FieldAccessor ENTITY_FIELD = null;
    private static FieldAccessor MAP_FIELD = null;
    private static ConstructorAccessor constructor = null;
    private static ConstructorAccessor eggConstructor = null;
    private static Object fakeEntity = null;

    public LegacyDataWatcher(Object handle) {
        super(HANDLE_TYPE);
        this.setHandle(handle);
    }

    @Deprecated
    public LegacyDataWatcher() {
        this(new ArrayList<WrappedWatchableObject>());
    }

    @Deprecated
    public LegacyDataWatcher(Entity entity) {
        this(LegacyDataWatcher.getHandleFromEntity(entity));
    }

    @Deprecated
    public LegacyDataWatcher(List<WrappedWatchableObject> objects) {
        this(LegacyDataWatcher.newHandle(LegacyDataWatcher.fakeEntity(), objects));
    }

    private static Object newHandle(Object entity, List<WrappedWatchableObject> objects) {
        if (constructor == null) {
            constructor = Accessors.getConstructorAccessor(HANDLE_TYPE, MinecraftReflection.getEntityClass(), MinecraftReflection.getArrayClass(MinecraftReflection.getDataWatcherItemClass()));
        }
        Object[] genericItems = new Object[]{};
        return constructor.invoke(entity, genericItems);
    }

    private static Object fakeEntity() {
        if (fakeEntity != null) {
            return fakeEntity;
        }
        if (eggConstructor == null) {
            eggConstructor = Accessors.getConstructorAccessor(MinecraftReflection.getMinecraftClass("world.entity.projectile.EntityEgg", "world.entity.projectile.ThrownEgg", "EntityEgg"), MinecraftReflection.getNmsWorldClass(), Double.TYPE, Double.TYPE, Double.TYPE);
        }
        Object world = BukkitUnwrapper.getInstance().unwrapItem(Bukkit.getWorlds().get(0));
        fakeEntity = eggConstructor.invoke(world, 0, 0, 0);
        return fakeEntity;
    }

    @Deprecated
    private Map<Integer, Object> getMap() {
        if (MAP_FIELD == null) {
            try {
                FuzzyReflection fuzzy = FuzzyReflection.fromClass(this.handleType, true);
                MAP_FIELD = Accessors.getFieldAccessor(fuzzy.getField(FuzzyFieldContract.newBuilder().banModifier(8).typeDerivedOf(Map.class).build()));
            }
            catch (IllegalArgumentException ex) {
                throw new FieldAccessException("Failed to find watchable object map", ex);
            }
        }
        return (Map)MAP_FIELD.get(this.handle);
    }

    @Override
    @Deprecated
    public Map<Integer, WrappedWatchableObject> asMap() {
        Map<Integer, Object> backingMap = this.getMap();
        return new ConvertedMap<Integer, Object, WrappedWatchableObject>(backingMap){

            @Override
            protected WrappedWatchableObject toOuter(Object inner) {
                return inner != null ? new WrappedWatchableObject(inner) : null;
            }

            @Override
            protected Object toInner(WrappedWatchableObject outer) {
                return outer != null ? outer.getHandle() : null;
            }
        };
    }

    @Override
    @Deprecated
    public Set<Integer> getIndexes() {
        return this.getMap().keySet();
    }

    @Override
    public List<WrappedWatchableObject> getWatchableObjects() {
        return new ArrayList<WrappedWatchableObject>(this.asMap().values());
    }

    @Override
    public Iterator<WrappedWatchableObject> iterator() {
        return this.getWatchableObjects().iterator();
    }

    @Override
    public int size() {
        return this.getMap().size();
    }

    @Override
    public WrappedWatchableObject getWatchableObject(int index) {
        Object handle = this.getMap().get(index);
        if (handle != null) {
            return new WrappedWatchableObject(handle);
        }
        return null;
    }

    @Deprecated
    public WrappedWatchableObject removeObject(int index) {
        return this.remove(index);
    }

    @Override
    public WrappedWatchableObject remove(int index) {
        Object removed = this.getMap().remove(index);
        return removed != null ? new WrappedWatchableObject(removed) : null;
    }

    @Override
    public boolean hasIndex(int index) {
        return this.getMap().containsKey(index);
    }

    @Deprecated
    public Set<Integer> indexSet() {
        return this.getIndexes();
    }

    @Override
    @Deprecated
    public void clear() {
        this.getMap().clear();
    }

    @Override
    public Object getObject(int index) {
        return this.getObject(WrappedDataWatcher.WrappedDataWatcherObject.fromIndex(index));
    }

    @Override
    public Object getObject(WrappedDataWatcher.WrappedDataWatcherObject object) {
        Validate.notNull((Object)object, (String)"Watcher object cannot be null!");
        if (GETTER == null) {
            FuzzyReflection fuzzy = FuzzyReflection.fromClass(this.handleType, true);
            GETTER = MinecraftReflection.watcherObjectExists() ? Accessors.getMethodAccessor(fuzzy.getMethod(FuzzyMethodContract.newBuilder().parameterExactType(object.getHandleType()).returnTypeExact(Object.class).build(), "get")) : Accessors.getMethodAccessor(fuzzy.getMethod(FuzzyMethodContract.newBuilder().parameterExactType(Integer.TYPE).returnTypeExact(MinecraftReflection.getDataWatcherItemClass()).build()));
        }
        try {
            Object value = GETTER.invoke(this.handle, object.getHandle());
            return WrappedWatchableObject.getWrapped(value);
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public void setObject(WrappedDataWatcher.WrappedDataWatcherObject object, WrappedWatchableObject value, boolean update) {
        this.setObject(object, value.getRawValue(), update);
    }

    @Override
    public void setObject(WrappedDataWatcher.WrappedDataWatcherObject object, Object value, boolean update) {
        Validate.notNull((Object)object, (String)"Watcher object cannot be null!");
        if (SETTER == null && REGISTER == null) {
            FuzzyReflection fuzzy = FuzzyReflection.fromClass(this.handleType, true);
            FuzzyMethodContract contract = FuzzyMethodContract.newBuilder().banModifier(8).requireModifier(1).parameterExactArray(object.getHandleType(), Object.class).build();
            List<Method> methods = fuzzy.getMethodList(contract);
            for (Method method : methods) {
                if (method.getName().equals("set") || method.getName().equals("watch") || method.getName().equals("b")) {
                    SETTER = Accessors.getMethodAccessor(method);
                    continue;
                }
                REGISTER = Accessors.getMethodAccessor(method);
            }
        }
        value = WrappedWatchableObject.getUnwrapped(value);
        if (this.hasIndex(object.getIndex())) {
            SETTER.invoke(this.handle, object.getHandle(), value);
        } else {
            object.checkSerializer();
            REGISTER.invoke(this.handle, object.getHandle(), value);
        }
        if (update) {
            this.getWatchableObject(object.getIndex()).setDirtyState(update);
        }
    }

    @Override
    public IDataWatcher deepClone() {
        LegacyDataWatcher clone = new LegacyDataWatcher(this.getEntity());
        for (WrappedWatchableObject wrapper : this) {
            clone.setObject(wrapper.getWatcherObject(), wrapper, false);
        }
        return clone;
    }

    private static Object getHandleFromEntity(Entity entity) {
        if (ENTITY_DATA_FIELD == null) {
            ENTITY_DATA_FIELD = Accessors.getFieldAccessor(MinecraftReflection.getEntityClass(), MinecraftReflection.getDataWatcherClass(), true);
        }
        BukkitUnwrapper unwrapper = new BukkitUnwrapper();
        Object handle = ENTITY_DATA_FIELD.get(unwrapper.unwrapItem(entity));
        return handle;
    }

    private Object getEntityHandle() {
        Object entity;
        if (ENTITY_FIELD == null) {
            ENTITY_FIELD = Accessors.getFieldAccessor(HANDLE_TYPE, MinecraftReflection.getEntityClass(), true);
        }
        if ((entity = ENTITY_FIELD.get(this.handle)) == null) {
            throw new NullPointerException(String.valueOf(this.handle) + "." + String.valueOf(ENTITY_FIELD));
        }
        return entity;
    }

    @Override
    public Entity getEntity() {
        Object entity = this.getEntityHandle();
        return (Entity)MinecraftReflection.getBukkitEntity(entity);
    }

    @Override
    public void setEntity(Entity entity) {
        if (ENTITY_FIELD == null) {
            ENTITY_FIELD = Accessors.getFieldAccessor(HANDLE_TYPE, MinecraftReflection.getEntityClass(), true);
        }
        ENTITY_FIELD.set(this.handle, BukkitUnwrapper.getInstance().unwrapItem(entity));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof LegacyDataWatcher) {
            LegacyDataWatcher other = (LegacyDataWatcher)obj;
            Iterator<WrappedWatchableObject> first = this.iterator();
            Iterator<WrappedWatchableObject> second = other.iterator();
            if (this.size() != other.size()) {
                return false;
            }
            while (first.hasNext() && second.hasNext()) {
                if (first.next().equals(second.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getWatchableObjects().hashCode();
    }

    @Override
    public String toString() {
        return "LegacyDataWatcher[handle=" + String.valueOf(this.handle) + "]";
    }
}

