/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.netty.channel;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolLogger;
import com.comphenix.protocol.error.ErrorReporter;
import com.comphenix.protocol.error.Report;
import com.comphenix.protocol.error.ReportType;
import com.comphenix.protocol.events.NetworkMarker;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.injector.ListenerManager;
import com.comphenix.protocol.injector.NetworkProcessor;
import com.comphenix.protocol.injector.netty.Injector;
import com.comphenix.protocol.injector.netty.WirePacket;
import com.comphenix.protocol.injector.netty.channel.ChannelProtocolUtil;
import com.comphenix.protocol.injector.netty.channel.InboundPacketInterceptor;
import com.comphenix.protocol.injector.netty.channel.InboundProtocolReader;
import com.comphenix.protocol.injector.netty.channel.InjectionFactory;
import com.comphenix.protocol.injector.netty.channel.NettyChannelProxy;
import com.comphenix.protocol.injector.netty.channel.NettyEventLoopProxy;
import com.comphenix.protocol.injector.netty.channel.PacketListenerInvoker;
import com.comphenix.protocol.injector.netty.channel.WirePacketEncoder;
import com.comphenix.protocol.injector.packet.PacketRegistry;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.FieldAccessor;
import com.comphenix.protocol.reflect.fuzzy.FuzzyFieldContract;
import com.comphenix.protocol.utility.MinecraftProtocolVersion;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.util.AttributeKey;
import java.lang.reflect.Field;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class NettyChannelInjector
implements Injector {
    private static final String INBOUND_INTERCEPTOR_NAME = "protocol_lib_inbound_interceptor";
    private static final String INBOUND_PROTOCOL_GETTER_NAME = "protocol_lib_inbound_protocol_getter";
    private static final String WIRE_PACKET_ENCODER_NAME = "protocol_lib_wire_packet_encoder";
    private static final String[] NETTY_HANDLER_NAMES = new String[]{"protocol_lib_wire_packet_encoder", "protocol_lib_inbound_interceptor", "protocol_lib_inbound_protocol_getter"};
    private static final ReportType REPORT_CANNOT_SEND_PACKET = new ReportType("Unable to send packet %s to %s");
    private static final ReportType REPORT_CANNOT_SEND_WRITE_PACKET = new ReportType("Unable to send wire packet %s to %s");
    private static final ReportType REPORT_CANNOT_READ_PACKET = new ReportType("Unable to read packet %s for %s");
    private static final ReportType REPORT_CANNOT_DISCONNECT = new ReportType("Unable to disconnect %s for %s");
    private static final WirePacketEncoder WIRE_PACKET_ENCODER = new WirePacketEncoder();
    private static final Map<Class<?>, FieldAccessor> PACKET_ACCESSORS = new ConcurrentHashMap(16, 0.9f);
    private static final AttributeKey<Integer> PROTOCOL_VERSION = AttributeKey.valueOf((String)NettyChannelInjector.getRandomKey());
    private static final AttributeKey<NettyChannelInjector> INJECTOR = AttributeKey.valueOf((String)NettyChannelInjector.getRandomKey());
    private final ErrorReporter errorReporter;
    private final InjectionFactory injectionFactory;
    private final ListenerManager listenerManager;
    private final NetworkProcessor networkProcessor;
    private final PacketListenerInvoker listenerInvoker;
    private final Object networkManager;
    private final Channel channel;
    private final FieldAccessor channelField;
    private final Map<Object, NetworkMarker> savedMarkers = new WeakHashMap<Object, NetworkMarker>(16, 0.9f);
    private final Set<Object> skippedPackets = ConcurrentHashMap.newKeySet();
    protected final ThreadLocal<Boolean> processedPackets = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private volatile boolean injected = false;
    private String playerName;
    private Player player;
    private volatile InboundProtocolReader inboundProtocolReader;

    static NettyChannelInjector findInjector(Channel channel) {
        return (NettyChannelInjector)channel.attr(INJECTOR).get();
    }

    private static String getRandomKey() {
        return "ProtocolLib-" + ThreadLocalRandom.current().nextLong();
    }

    public NettyChannelInjector(Player player, Object networkManager, Channel channel, ListenerManager listenerManager, InjectionFactory injector, ErrorReporter errorReporter) {
        this.player = player;
        this.errorReporter = errorReporter;
        this.networkProcessor = new NetworkProcessor(errorReporter);
        this.listenerInvoker = new PacketListenerInvoker(networkManager);
        this.networkManager = networkManager;
        this.channel = channel;
        this.listenerManager = listenerManager;
        this.injectionFactory = injector;
        this.channel.attr(INJECTOR).set((Object)this);
        Field channelField = FuzzyReflection.fromObject(networkManager, true).getField(FuzzyFieldContract.newBuilder().typeExact(Channel.class).banModifier(8).build());
        this.channelField = Accessors.getFieldAccessor(channelField);
        this.channel.closeFuture().addListener(future -> this.close());
    }

    @Override
    public SocketAddress getAddress() {
        return this.channel.remoteAddress();
    }

    @Override
    public int getProtocolVersion() {
        Integer protocolVersion = (Integer)this.channel.attr(PROTOCOL_VERSION).get();
        return protocolVersion == null ? MinecraftProtocolVersion.getCurrentVersion() : protocolVersion;
    }

    @Override
    public void inject() {
        String decoderName;
        ChannelPipeline pipeline;
        if (!this.channel.eventLoop().inEventLoop()) {
            this.channel.eventLoop().execute(this::inject);
            return;
        }
        if (this.closed.get() || !this.channel.isActive()) {
            return;
        }
        Object networkManangerChannel = this.channelField.get(this.networkManager);
        if (!(networkManangerChannel instanceof NettyChannelProxy)) {
            NettyEventLoopProxy proxyEventLoop = new NettyEventLoopProxy(this.channel.eventLoop(), this);
            NettyChannelProxy proxyChannel = new NettyChannelProxy(this.channel, proxyEventLoop, this);
            this.channelField.set(this.networkManager, proxyChannel);
        }
        String encoderName = (pipeline = this.channel.pipeline()).get("outbound_config") != null ? "outbound_config" : "encoder";
        String string = decoderName = pipeline.get("inbound_config") != null ? "inbound_config" : "decoder";
        if (pipeline.context(WIRE_PACKET_ENCODER_NAME) == null) {
            pipeline.addAfter(encoderName, WIRE_PACKET_ENCODER_NAME, (ChannelHandler)WIRE_PACKET_ENCODER);
        }
        if (MinecraftVersion.CONFIG_PHASE_PROTOCOL_UPDATE.atOrAbove() && pipeline.context(INBOUND_PROTOCOL_GETTER_NAME) == null) {
            this.inboundProtocolReader = new InboundProtocolReader(this);
            pipeline.addBefore(decoderName, INBOUND_PROTOCOL_GETTER_NAME, (ChannelHandler)this.inboundProtocolReader);
        }
        if (pipeline.context(INBOUND_INTERCEPTOR_NAME) == null) {
            pipeline.addAfter(decoderName, INBOUND_INTERCEPTOR_NAME, (ChannelHandler)new InboundPacketInterceptor(this));
        }
        this.injected = true;
    }

    private void uninject() {
        if (!this.channel.eventLoop().inEventLoop()) {
            this.channel.eventLoop().execute(this::uninject);
            return;
        }
        this.channelField.set(this.networkManager, this.channel);
        ChannelPipeline pipeline = this.channel.pipeline();
        for (String handlerName : NETTY_HANDLER_NAMES) {
            if (pipeline.context(handlerName) == null) continue;
            pipeline.remove(handlerName);
        }
        this.injected = false;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.uninject();
            this.channel.attr(INJECTOR).remove();
            this.savedMarkers.clear();
            this.skippedPackets.clear();
            this.injectionFactory.invalidate(this.getPlayer(), this.playerName);
        }
    }

    @Override
    public void sendClientboundPacket(Object packet, NetworkMarker marker, boolean filtered) {
        if (this.closed.get() || !this.injected) {
            return;
        }
        if (!filtered) {
            this.skippedPackets.add(packet);
        }
        if (marker != null) {
            this.savedMarkers.put(packet, marker);
        }
        try {
            this.listenerInvoker.send(packet);
        }
        catch (Exception exception) {
            this.errorReporter.reportWarning((Object)this, Report.newBuilder(REPORT_CANNOT_SEND_PACKET).messageParam(packet, this.playerName).error(exception).build());
        }
    }

    @Override
    public void readServerboundPacket(Object packet) {
        if (this.closed.get() || !this.injected) {
            return;
        }
        this.ensureInEventLoop(() -> {
            try {
                this.listenerInvoker.read(packet);
            }
            catch (Exception exception) {
                this.errorReporter.reportWarning((Object)this, Report.newBuilder(REPORT_CANNOT_READ_PACKET).messageParam(packet, this.playerName).error(exception).build());
            }
        });
    }

    @Override
    public void sendWirePacket(WirePacket packet) {
        if (this.closed.get() || !this.injected) {
            return;
        }
        this.ensureInEventLoop(() -> {
            try {
                this.channel.writeAndFlush((Object)packet);
            }
            catch (Exception exception) {
                this.errorReporter.reportWarning((Object)this, Report.newBuilder(REPORT_CANNOT_SEND_WRITE_PACKET).messageParam(packet, this.playerName).error(exception).build());
            }
        });
    }

    @Override
    public void disconnect(String message) {
        if (this.closed.get() || !this.injected) {
            return;
        }
        try {
            this.listenerInvoker.disconnect(message);
        }
        catch (Exception exception) {
            this.errorReporter.reportWarning((Object)this, Report.newBuilder(REPORT_CANNOT_DISCONNECT).messageParam(this.playerName, message).error(exception).build());
        }
    }

    @Override
    public PacketType.Protocol getCurrentProtocol(PacketType.Sender sender) {
        return ChannelProtocolUtil.PROTOCOL_RESOLVER.apply(this.channel, sender);
    }

    @Override
    public Player getPlayer() {
        if (this.player != null) {
            return this.player;
        }
        if (this.playerName != null) {
            this.player = Bukkit.getPlayerExact((String)this.playerName);
            if (this.player != null) {
                this.injectionFactory.cacheInjector(this.player, (Injector)this);
            }
        }
        return this.player;
    }

    @Override
    public void setPlayer(Player player) {
        this.injectionFactory.invalidate(this.player, this.playerName);
        this.player = player;
        this.playerName = player.getName();
        this.injectionFactory.cacheInjector(player, (Injector)this);
        this.injectionFactory.cacheInjector(player.getName(), (Injector)this);
    }

    @Override
    public boolean isConnected() {
        return this.channel.isActive();
    }

    @Override
    public boolean isInjected() {
        return this.injected;
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    PacketType.Protocol getInboundProtocol() {
        if (this.inboundProtocolReader != null) {
            return this.inboundProtocolReader.getProtocol();
        }
        return this.getCurrentProtocol(PacketType.Sender.CLIENT);
    }

    boolean hasInboundListener(PacketType type) {
        return type == PacketType.Handshake.Client.SET_PROTOCOL || type == PacketType.Login.Client.START || this.listenerManager.hasInboundListener(type);
    }

    void processInbound(ChannelHandlerContext ctx, PacketContainer packet) {
        Integer protocolVersion;
        if (packet.getType() == PacketType.Handshake.Client.SET_PROTOCOL && (protocolVersion = packet.getIntegers().readSafely(0)) != null) {
            this.channel.attr(PROTOCOL_VERSION).set((Object)protocolVersion);
        }
        if (packet.getType() == PacketType.Login.Client.START) {
            String username;
            if (MinecraftVersion.WILD_UPDATE.atOrAbove()) {
                username = packet.getStrings().readSafely(0);
            } else {
                WrappedGameProfile profile = packet.getGameProfiles().readSafely(0);
                String string = username = profile != null ? profile.getName() : null;
            }
            if (username != null) {
                this.playerName = username;
                this.injectionFactory.cacheInjector(username, (Injector)this);
            }
        }
        if (this.listenerManager.hasInboundListener(packet.getType())) {
            this.processInboundInternal(ctx, packet);
        } else {
            ctx.fireChannelRead(packet.getHandle());
        }
    }

    private void processInboundInternal(ChannelHandlerContext ctx, PacketContainer packetContainer) {
        if (this.listenerManager.hasMainThreadListener(packetContainer.getType()) && !Bukkit.isPrimaryThread()) {
            ProtocolLibrary.getScheduler().runTask(() -> this.processInboundInternal(ctx, packetContainer));
            return;
        }
        PacketEvent event = PacketEvent.fromClient(this, packetContainer, this.player);
        this.listenerManager.invokeInboundPacketListeners(event);
        Object packet = event.getPacket().getHandle();
        if (!event.isCancelled() && packet != null) {
            this.ensureInEventLoop(ctx.channel().eventLoop(), () -> ctx.fireChannelRead(packet));
            NetworkMarker marker = NetworkMarker.getNetworkMarker(event);
            if (marker != null) {
                this.networkProcessor.invokePostEvent(event, marker);
            }
        }
    }

    <T> T processOutbound(T action) {
        NetworkMarker marker;
        FieldAccessor packetAccessor = this.lookupPacketAccessor(action);
        if (packetAccessor == FieldAccessor.NO_OP_ACCESSOR) {
            return action;
        }
        Object packet = packetAccessor.get(action);
        if (packet == null) {
            return action;
        }
        NetworkMarker networkMarker = marker = this.savedMarkers.isEmpty() ? null : this.savedMarkers.remove(packet);
        if (!this.skippedPackets.isEmpty() && this.skippedPackets.remove(packet)) {
            if (marker != null) {
                return this.proxyAction(action, null, marker);
            }
            return action;
        }
        PacketType.Protocol protocol = this.getCurrentProtocol(PacketType.Sender.SERVER);
        if (protocol == PacketType.Protocol.UNKNOWN) {
            ProtocolLogger.debug("skipping unknown outbound protocol for {0}", packet.getClass());
            return action;
        }
        PacketType packetType = PacketRegistry.getPacketType(protocol, packet.getClass());
        if (packetType == null) {
            ProtocolLogger.debug("skipping unknown outbound packet type for {0}", packet.getClass());
            return action;
        }
        if (!this.listenerManager.hasOutboundListener(packetType) && marker == null && !MinecraftReflection.isBundlePacket(packet.getClass())) {
            return action;
        }
        if (this.listenerManager.hasMainThreadListener(packetType) && !Bukkit.isPrimaryThread()) {
            ProtocolLibrary.getScheduler().runTask(() -> this.sendClientboundPacket(packet, null, true));
            return null;
        }
        PacketContainer packetContainer = new PacketContainer(packetType, packet);
        PacketEvent event = PacketEvent.fromServer(this, packetContainer, marker, this.player);
        this.listenerManager.invokeOutboundPacketListeners(event);
        Object interceptedPacket = event.getPacket().getHandle();
        if (!event.isCancelled() && interceptedPacket != null) {
            NetworkMarker eventMarker;
            if (interceptedPacket != packet) {
                packetAccessor.set(action, interceptedPacket);
            }
            if ((eventMarker = NetworkMarker.getNetworkMarker(event)) == null) {
                return action;
            }
            return this.proxyAction(action, event, eventMarker);
        }
        return null;
    }

    private <T> T proxyAction(T action, PacketEvent event, NetworkMarker marker) {
        if (action instanceof Runnable) {
            return (T)((Runnable)() -> {
                this.processedPackets.set(Boolean.TRUE);
                ((Runnable)action).run();
                this.networkProcessor.invokePostEvent(event, marker);
            });
        }
        if (action instanceof Callable) {
            return (T)((Callable<Object>)() -> {
                this.processedPackets.set(Boolean.TRUE);
                Object value = ((Callable)action).call();
                this.networkProcessor.invokePostEvent(event, marker);
                return value;
            });
        }
        throw new IllegalStateException("Unexpected input action of type " + String.valueOf(action.getClass()));
    }

    private FieldAccessor lookupPacketAccessor(Object action) {
        return PACKET_ACCESSORS.computeIfAbsent(action.getClass(), key -> {
            try {
                Field packetField = FuzzyReflection.fromClass(key, true).getField(FuzzyFieldContract.newBuilder().typeSuperOf(MinecraftReflection.getPacketClass()).build());
                return Accessors.getFieldAccessor(packetField);
            }
            catch (IllegalArgumentException exception) {
                return FieldAccessor.NO_OP_ACCESSOR;
            }
        });
    }

    private void ensureInEventLoop(Runnable runnable) {
        this.ensureInEventLoop(this.channel.eventLoop(), runnable);
    }

    private void ensureInEventLoop(EventLoop eventLoop, Runnable runnable) {
        if (eventLoop.inEventLoop()) {
            runnable.run();
        } else {
            eventLoop.execute(runnable);
        }
    }
}

