/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.api.manager;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.lucko.luckperms.api.HeldPermission;
import me.lucko.luckperms.api.PlayerSaveResult;
import me.lucko.luckperms.api.User;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface UserManager {
    public @NonNull CompletableFuture<User> loadUser(@NonNull UUID var1, @Nullable String var2);

    default public @NonNull CompletableFuture<User> loadUser(@NonNull UUID uuid) {
        return this.loadUser(uuid, null);
    }

    public @NonNull CompletableFuture<UUID> lookupUuid(@NonNull String var1);

    public @NonNull CompletableFuture<String> lookupUsername(@NonNull UUID var1);

    public @NonNull CompletableFuture<Void> saveUser(@NonNull User var1);

    public @NonNull CompletableFuture<PlayerSaveResult> savePlayerData(@NonNull UUID var1, @NonNull String var2);

    public @NonNull CompletableFuture<Set<UUID>> getUniqueUsers();

    public @NonNull CompletableFuture<List<HeldPermission<UUID>>> getWithPermission(@NonNull String var1);

    public @Nullable User getUser(@NonNull UUID var1);

    default public @NonNull Optional<User> getUserOpt(@NonNull UUID uuid) {
        return Optional.ofNullable(this.getUser(uuid));
    }

    public @Nullable User getUser(@NonNull String var1);

    default public @NonNull Optional<User> getUserOpt(@NonNull String name) {
        return Optional.ofNullable(this.getUser(name));
    }

    public @NonNull Set<User> getLoadedUsers();

    public boolean isLoaded(@NonNull UUID var1);

    public void cleanupUser(@NonNull User var1);
}

