/*
 * Decompiled with CFR 0.152.
 */
package me.wolfyscript.utilities.org.mozilla.javascript;

import me.wolfyscript.utilities.org.mozilla.javascript.Context;
import me.wolfyscript.utilities.org.mozilla.javascript.ES6Iterator;
import me.wolfyscript.utilities.org.mozilla.javascript.NativeArray;
import me.wolfyscript.utilities.org.mozilla.javascript.Scriptable;
import me.wolfyscript.utilities.org.mozilla.javascript.ScriptableObject;
import me.wolfyscript.utilities.org.mozilla.javascript.Undefined;

public final class NativeArrayIterator
extends ES6Iterator {
    private static final long serialVersionUID = 1L;
    private static final String ITERATOR_TAG = "ArrayIterator";
    private ARRAY_ITERATOR_TYPE type;
    private Scriptable arrayLike;
    private int index;

    private NativeArrayIterator() {
    }

    public NativeArrayIterator(Scriptable scope, Scriptable arrayLike, ARRAY_ITERATOR_TYPE type) {
        super(scope, ITERATOR_TAG);
        this.index = 0;
        this.arrayLike = arrayLike;
        this.type = type;
    }

    static void init(ScriptableObject scope, boolean sealed) {
        ES6Iterator.init(scope, sealed, new NativeArrayIterator(), ITERATOR_TAG);
    }

    @Override
    public String getClassName() {
        return "Array Iterator";
    }

    @Override
    protected boolean isDone(Context cx, Scriptable scope) {
        return (long)this.index >= NativeArray.getLengthProperty(cx, this.arrayLike, false);
    }

    @Override
    protected Object nextValue(Context cx, Scriptable scope) {
        if (this.type == ARRAY_ITERATOR_TYPE.KEYS) {
            return this.index++;
        }
        Object value = this.arrayLike.get(this.index, this.arrayLike);
        if (value == ScriptableObject.NOT_FOUND) {
            value = Undefined.instance;
        }
        if (this.type == ARRAY_ITERATOR_TYPE.ENTRIES) {
            value = cx.newArray(scope, new Object[]{this.index, value});
        }
        ++this.index;
        return value;
    }

    @Override
    protected String getTag() {
        return ITERATOR_TAG;
    }

    public static enum ARRAY_ITERATOR_TYPE {
        ENTRIES,
        KEYS,
        VALUES;

    }
}

