/*
 * Decompiled with CFR 0.152.
 */
package me.wolfyscript.utilities.api.utils.particles;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import me.wolfyscript.utilities.api.config.ConfigAPI;
import me.wolfyscript.utilities.api.config.JsonConfiguration;
import me.wolfyscript.utilities.api.utils.NamespacedKey;
import me.wolfyscript.utilities.api.utils.particles.ParticleEffect;
import me.wolfyscript.utilities.main.Main;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class ParticleEffects
extends JsonConfiguration {
    private static Map<NamespacedKey, ParticleEffect> particleEffects = new HashMap<NamespacedKey, ParticleEffect>();
    private static LinkedHashMap<UUID, BukkitTask> currentEffects = new LinkedHashMap();
    private String namespace;

    public ParticleEffects(ConfigAPI configAPI) {
        this(configAPI, "", configAPI.getPlugin().getDataFolder().getPath(), "me/wolfyscript/utilities/api/utils/particles/defaults");
    }

    public ParticleEffects(ConfigAPI configAPI, String namespace) {
        this(configAPI, namespace, false);
    }

    public ParticleEffects(ConfigAPI configAPI, String namespace, boolean override) {
        this(configAPI, namespace, configAPI.getPlugin().getDataFolder().getPath(), override);
    }

    public ParticleEffects(ConfigAPI configAPI, String namespace, String path) {
        this(configAPI, namespace, path, false);
    }

    public ParticleEffects(ConfigAPI configAPI, String namespace, String path, boolean override) {
        this(configAPI, namespace, path, "me/wolfyscript/utilities/api/utils/particles/defaults", override);
    }

    public ParticleEffects(ConfigAPI configAPI, String namespace, String path, String defPath) {
        this(configAPI, namespace, path, defPath, false);
    }

    public ParticleEffects(ConfigAPI configAPI, String namespace, String path, String defPath, boolean override) {
        super(configAPI, path + File.separator + (namespace.isEmpty() ? "" : namespace + File.separator) + "particles", "particle_effects", defPath, "particle_effects", override);
        this.namespace = namespace.isEmpty() ? configAPI.getPlugin().getName().toLowerCase(Locale.ROOT).replace(" ", "_") : namespace;
    }

    public static Map<NamespacedKey, ParticleEffect> getEffects() {
        return new HashMap<NamespacedKey, ParticleEffect>(particleEffects);
    }

    public static ParticleEffect getEffect(NamespacedKey nameSpacedKey) {
        return particleEffects.get(nameSpacedKey);
    }

    public static void addOrReplaceEffect(NamespacedKey nameSpacedKey, ParticleEffect particle) {
        particleEffects.put(nameSpacedKey, particle);
    }

    public static void addEffect(NamespacedKey nameSpacedKey, ParticleEffect particle) {
        if (!particleEffects.containsKey(nameSpacedKey)) {
            particleEffects.put(nameSpacedKey, particle);
        }
    }

    @Override
    public void reload() {
        super.reload(true);
    }

    @Override
    public void save() {
        super.save(true);
    }

    public static void stopEffect(UUID uuid) {
        BukkitTask task;
        if (uuid != null && (task = currentEffects.get(uuid)) != null) {
            task.cancel();
            currentEffects.remove(uuid);
        }
    }

    public static UUID spawnEffectOnBlock(NamespacedKey nameSpacedKey, final Block block) {
        final ParticleEffect particleEffect = ParticleEffects.getEffect(nameSpacedKey);
        if (particleEffect != null) {
            UUID id = UUID.randomUUID();
            while (currentEffects.containsKey(id)) {
                id = UUID.randomUUID();
            }
            BukkitTask cooldownTask = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)Main.getInstance(), () -> {
                AtomicBoolean allow = new AtomicBoolean(true);
                Bukkit.getScheduler().runTask((Plugin)Main.getInstance(), () -> allow.set(block.getWorld().getNearbyEntities(block.getLocation(), 25.0, 25.0, 25.0, entity -> entity instanceof Player).isEmpty()));
                if (allow.get()) {
                    particleEffect.prepare();
                    final AtomicInteger i = new AtomicInteger();
                    new BukkitRunnable(){

                        public void run() {
                            particleEffect.spawnOnBlock(block, i.get());
                            if (i.get() < particleEffect.getDuration()) {
                                i.getAndIncrement();
                            } else {
                                this.cancel();
                            }
                        }
                    }.runTaskTimerAsynchronously((Plugin)Main.getInstance(), 1L, 1L);
                }
            }, (long)particleEffect.getCooldown(), (long)(particleEffect.getCooldown() + particleEffect.getDuration() + 1));
            currentEffects.put(id, cooldownTask);
            return id;
        }
        return null;
    }

    public static UUID spawnEffectOnLocation(NamespacedKey nameSpacedKey, final Location location) {
        final ParticleEffect particleEffect = ParticleEffects.getEffect(nameSpacedKey);
        if (particleEffect != null) {
            UUID id = UUID.randomUUID();
            System.out.println();
            while (currentEffects.containsKey(id)) {
                id = UUID.randomUUID();
            }
            BukkitTask cooldownTask = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)Main.getInstance(), () -> {
                AtomicBoolean allow = new AtomicBoolean(true);
                Bukkit.getScheduler().runTask((Plugin)Main.getInstance(), () -> allow.set(location.getWorld().getNearbyEntities(location, 25.0, 25.0, 25.0, entity -> entity instanceof Player).isEmpty()));
                if (allow.get()) {
                    particleEffect.prepare();
                    final AtomicInteger i = new AtomicInteger();
                    new BukkitRunnable(){

                        public void run() {
                            particleEffect.spawnOnLocation(location, i.get());
                            if (i.get() < particleEffect.getDuration()) {
                                i.getAndIncrement();
                            } else {
                                this.cancel();
                            }
                        }
                    }.runTaskTimerAsynchronously((Plugin)Main.getInstance(), 1L, 1L);
                }
            }, (long)particleEffect.getCooldown(), (long)(particleEffect.getCooldown() + particleEffect.getDuration() + 1));
            currentEffects.put(id, cooldownTask);
            return id;
        }
        return null;
    }

    public static UUID spawnEffectOnPlayer(NamespacedKey nameSpacedKey, final EquipmentSlot slot, Player player) {
        final ParticleEffect particleEffect = ParticleEffects.getEffect(nameSpacedKey);
        if (particleEffect != null) {
            UUID id = UUID.randomUUID();
            while (currentEffects.containsKey(id)) {
                id = UUID.randomUUID();
            }
            UUID playerID = player.getUniqueId();
            BukkitTask cooldownTask = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)Main.getInstance(), () -> {
                particleEffect.prepare();
                final Player currentPlayer = Bukkit.getPlayer((UUID)playerID);
                final AtomicInteger i = new AtomicInteger();
                if (currentPlayer != null && currentPlayer.isOnline() && currentPlayer.isValid()) {
                    new BukkitRunnable(){

                        public void run() {
                            particleEffect.spawnOnPlayer(currentPlayer, slot, i.get());
                            if (i.get() < particleEffect.getDuration()) {
                                i.getAndIncrement();
                            } else {
                                this.cancel();
                            }
                        }
                    }.runTaskTimerAsynchronously((Plugin)Main.getInstance(), 1L, 1L);
                }
            }, (long)particleEffect.getCooldown(), (long)(particleEffect.getCooldown() + particleEffect.getDuration() + 1));
            currentEffects.put(id, cooldownTask);
            return id;
        }
        return null;
    }

    public void loadEffects() {
        for (String key : this.getKeys()) {
            ParticleEffect particleEffect = this.get(ParticleEffect.class, key);
            if (particleEffect == null) continue;
            particleEffect.setReferencePath(this.getConfigFile().getParent());
            particleEffects.put(new NamespacedKey(this.namespace, key), particleEffect);
        }
    }

    public void setEffects() {
        for (Map.Entry<NamespacedKey, ParticleEffect> particleEntry : particleEffects.entrySet()) {
            if (!particleEntry.getKey().getNamespace().equalsIgnoreCase(this.namespace)) continue;
            this.set(particleEntry.getKey().getKey(), particleEntry.getValue());
        }
    }
}

