/*
 * Decompiled with CFR 0.152.
 */
package me.wolfyscript.utilities.api.inventory.button.buttons;

import me.wolfyscript.utilities.api.WolfyUtilities;
import me.wolfyscript.utilities.api.inventory.GuiHandler;
import me.wolfyscript.utilities.api.inventory.GuiWindow;
import me.wolfyscript.utilities.api.inventory.button.Button;
import me.wolfyscript.utilities.api.inventory.button.ButtonState;
import me.wolfyscript.utilities.api.inventory.button.ButtonType;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;

public class ActionButton
extends Button {
    private String id;
    private ButtonType type;
    private ButtonState state;

    public ActionButton(String id, ButtonType type, ButtonState state) {
        super(id, type);
        this.id = id;
        this.type = type;
        this.state = state;
    }

    public ActionButton(String id, ButtonState state) {
        this(id, ButtonType.NORMAL, state);
    }

    @Override
    public void init(GuiWindow guiWindow) {
        this.state.init(guiWindow);
    }

    @Override
    public void init(String windowKey, WolfyUtilities api) {
        this.state.init(windowKey, api);
    }

    @Override
    public boolean execute(GuiHandler guiHandler, Player player, Inventory inventory, int slot, InventoryClickEvent event) {
        if (!this.type.equals((Object)ButtonType.DUMMY) && this.state.getAction() != null) {
            return this.state.getAction().run(guiHandler, player, inventory, slot, event);
        }
        return true;
    }

    @Override
    public void render(GuiHandler guiHandler, Player player, Inventory inventory, int slot, boolean help) {
        this.applyItem(guiHandler, player, inventory, this.state, slot, help);
    }

    @Override
    public ButtonType getType() {
        return this.type;
    }

    public ButtonState getState() {
        return this.state;
    }

    @Override
    public String getId() {
        return this.id;
    }
}

